/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.connector.ClientHelper;
import org.restlet.engine.local.Entity;
import org.restlet.engine.util.SystemUtils;
import org.restlet.representation.InputRepresentation;

@Deprecated
public class FtpClientHelper
extends ClientHelper {
    public FtpClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.FTP);
    }

    public int getReadTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("readTimeout", "60000"));
    }

    public int getSocketConnectTimeoutMs() {
        int result = 0;
        if (this.getHelpedParameters().getNames().contains("socketConnectTimeoutMs")) {
            result = Integer.parseInt(this.getHelpedParameters().getFirstValue("socketConnectTimeoutMs", "15000"));
        }
        return result;
    }

    @Override
    public void handle(Request request, Response response) {
        try {
            if (Protocol.FTP.equals(request.getProtocol())) {
                if (Method.GET.equals(request.getMethod())) {
                    Reference ftpRef = request.getResourceRef();
                    Object userInfo = null;
                    if (request.getChallengeResponse() != null && ChallengeScheme.FTP_PLAIN.equals(request.getChallengeResponse().getScheme()) && request.getChallengeResponse().getIdentifier() != null) {
                        userInfo = request.getChallengeResponse().getIdentifier();
                        if (request.getChallengeResponse().getSecret() != null) {
                            userInfo = (String)userInfo + ":" + new String(request.getChallengeResponse().getSecret());
                        }
                    }
                    if (userInfo != null) {
                        ftpRef.setUserInfo((String)userInfo);
                    }
                    URL url = ftpRef.toUrl();
                    URLConnection connection = url.openConnection();
                    int majorVersionNumber = SystemUtils.getJavaMajorVersion();
                    int minorVersionNumber = SystemUtils.getJavaMinorVersion();
                    if (majorVersionNumber > 1 || majorVersionNumber == 1 && minorVersionNumber >= 5) {
                        connection.setConnectTimeout(this.getSocketConnectTimeoutMs());
                        connection.setReadTimeout(this.getReadTimeout());
                    }
                    connection.setAllowUserInteraction(this.isAllowUserInteraction());
                    connection.setUseCaches(this.isUseCaches());
                    response.setEntity(new InputRepresentation(connection.getInputStream()));
                    Entity.updateMetadata(request.getResourceRef().getPath(), response.getEntity(), true, this.getMetadataService());
                } else {
                    this.getLogger().log(Level.WARNING, "Only GET method are supported by this FTP connector");
                }
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "FTP client error", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e.getMessage());
        }
    }

    public boolean isAllowUserInteraction() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("allowUserInteraction", "false"));
    }

    public boolean isUseCaches() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("useCaches", "false"));
    }

    @Override
    public synchronized void start() throws Exception {
        super.start();
        this.getLogger().info("Starting the internal FTP client");
    }

    @Override
    public synchronized void stop() throws Exception {
        super.stop();
        this.getLogger().info("Stopping the internal FTP client");
    }
}

