/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Arrays;
import org.restlet.engine.util.SystemUtils;

public class Digest {
    public static final String ALGORITHM_MD2 = "MD2";
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_NONE = "NONE";
    public static final String ALGORITHM_SHA_1 = "SHA-1";
    public static final String ALGORITHM_SHA_256 = "SHA-256";
    public static final String ALGORITHM_SHA_384 = "SHA-384";
    public static final String ALGORITHM_SHA_512 = "SHA-512";
    public static final String ALGORITHM_HTTP_DIGEST = "HTTP-DIGEST-A1";
    private final String algorithm;
    private final byte[] value;

    public Digest(byte[] value) {
        this(ALGORITHM_MD5, value);
    }

    public Digest(String algorithm, byte[] value) {
        this.algorithm = algorithm;
        this.value = new byte[value.length];
        System.arraycopy(value, 0, this.value, 0, value.length);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Digest) {
            Digest that = (Digest)obj;
            if (this.getAlgorithm().equals(that.getAlgorithm())) {
                return Arrays.equals(this.getValue(), that.getValue());
            }
        }
        return false;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getValue() {
        byte[] result = new byte[this.value.length];
        System.arraycopy(this.value, 0, result, 0, this.value.length);
        return result;
    }

    public int hashCode() {
        return SystemUtils.hashCode(this.algorithm, this.value);
    }

    public String toString() {
        return "Digest [algorithm=" + this.algorithm + ", value=" + Arrays.toString(this.value) + "]";
    }
}

