/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.converter.ConverterUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;
import org.restlet.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterService
extends Service {
    public ConverterService() {
    }

    public ConverterService(boolean enabled) {
        super(enabled);
    }

    public List<Class<?>> getObjectClasses(Variant sourceVariant) {
        ArrayList result = null;
        List<Class<?>> helperObjectClasses = null;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            helperObjectClasses = ch.getObjectClasses(sourceVariant);
            if (helperObjectClasses == null) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(helperObjectClasses);
        }
        return result;
    }

    public List<Variant> getVariants(Class<?> sourceClass, Variant targetVariant) {
        ArrayList<Variant> result = null;
        List<Variant> helperVariants = null;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            helperVariants = ch.getVariants(sourceClass);
            if (helperVariants == null) continue;
            if (result == null) {
                result = new ArrayList<Variant>();
            }
            result.addAll(helperVariants);
        }
        return result;
    }

    public Object toObject(Representation sourceRepresentation) throws IOException {
        return this.toObject(sourceRepresentation, null, null);
    }

    public <T> T toObject(Representation sourceRepresentation, Class<T> targetClass, UniformResource resource) throws IOException {
        Representation result = null;
        if (sourceRepresentation != null && sourceRepresentation.isAvailable()) {
            ConverterHelper ch = ConverterUtils.getHelper(sourceRepresentation, targetClass, resource);
            if (ch != null) {
                result = (Representation)ch.toObject(sourceRepresentation, targetClass, resource);
            } else if (targetClass.isAssignableFrom(sourceRepresentation.getClass())) {
                result = sourceRepresentation;
            } else {
                Context.getCurrentLogger().warning("Unable to find a converter for this representation : " + sourceRepresentation);
            }
        }
        return (T)result;
    }

    public Representation toRepresentation(Object sourceObject) {
        return this.toRepresentation(sourceObject, null, null);
    }

    public Representation toRepresentation(Object sourceObject, Variant targetVariant, UniformResource resource) {
        Representation result = null;
        ConverterHelper ch = ConverterUtils.getHelper(sourceObject, targetVariant, resource);
        if (ch != null) {
            try {
                result = ch.toRepresentation(sourceObject, targetVariant, resource);
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to convert object to a representation", e);
            }
        } else {
            Context.getCurrentLogger().warning("Unable to find a converter for this object : " + sourceObject);
        }
        return result;
    }
}

