/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.routing.Filter;
import org.restlet.security.Authenticator;
import org.restlet.security.Authorizer;

public class UniformGuard
extends Filter {
    private Authenticator authenticator;
    private Authorizer authorizer;

    public UniformGuard(Context context, Authenticator authenticator, Authorizer authorizer) {
        super(context);
        this.setAuthenticator(authenticator);
        this.setAuthorizer(authorizer);
    }

    protected int beforeHandle(Request request, Response response) {
        if (response.getStatus().isSuccess() && this.getAuthenticator() != null) {
            this.getAuthenticator().handle(request, response);
        }
        if (response.getStatus().isSuccess() && this.getAuthorizer() != null) {
            this.getAuthorizer().handle(request, response);
        }
        return response.getStatus().isError() ? 2 : 0;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        Filter next = authenticator;
        while (next != null) {
            if (next.getNext() == null) {
                next.setNext(new Restlet(){});
                next = null;
                continue;
            }
            if (next.getNext() instanceof Filter) {
                next = (Filter)next.getNext();
                continue;
            }
            next = null;
        }
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
        Filter next = authorizer;
        while (next != null) {
            if (next.getNext() == null) {
                next.setNext(new Restlet(){});
                next = null;
                continue;
            }
            if (next.getNext() instanceof Filter) {
                next = (Filter)next.getNext();
                continue;
            }
            next = null;
        }
    }
}

