/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.Subject;
import org.restlet.Context;
import org.restlet.engine.security.RoleMapping;
import org.restlet.security.Enroler;
import org.restlet.security.Group;
import org.restlet.security.LocalVerifier;
import org.restlet.security.Organization;
import org.restlet.security.Realm;
import org.restlet.security.Role;
import org.restlet.security.RolePrincipal;
import org.restlet.security.User;
import org.restlet.security.UserPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryRealm
extends Realm {
    private List<Organization> organizations;
    private final List<RoleMapping> roleMappings;

    public MemoryRealm() {
        this.setVerifier(new DefaultVerifier());
        this.setEnroler(new DefaultEnroler());
        this.organizations = new CopyOnWriteArrayList<Organization>();
        this.roleMappings = new CopyOnWriteArrayList<RoleMapping>();
    }

    public Organization findOrganization(String domainName) {
        for (Organization org : this.getOrganizations()) {
            if (!org.getDomainName().equals(domainName)) continue;
            return org;
        }
        return null;
    }

    public Set<Role> findRoles(Organization userOrganization, Set<Group> userGroups, User user) {
        HashSet<Role> result = new HashSet<Role>();
        for (RoleMapping mapping : this.getRoleMappings()) {
            Object source = mapping.getSource();
            if (!userOrganization.equals(source) && !user.equals(source) && !userGroups.contains(source)) continue;
            result.add(mapping.getTarget());
        }
        return result;
    }

    public User findUser(Organization organization, String identifier) {
        String userIdentifier;
        User result = null;
        int at = identifier.indexOf(64);
        String string = userIdentifier = at == -1 ? identifier : identifier.substring(0, at);
        if (organization != null) {
            result = organization.findUser(userIdentifier);
        }
        return result;
    }

    public User findUser(String identifier) {
        return this.findUser(this.findUserOrganization(identifier), identifier);
    }

    public Organization findUserOrganization(String identifier) {
        String domainName;
        Organization result = null;
        int at = identifier.indexOf(64);
        String string = domainName = at == -1 ? null : identifier.substring(at + 1);
        if (domainName == null) {
            if (this.getOrganizations().size() == 1) {
                result = this.getOrganizations().get(0);
            } else {
                Context.getCurrentLogger().info("Unable to identify an unqualified user. Multiple organizations were bounded.");
            }
        } else {
            result = this.findOrganization(domainName);
        }
        return result;
    }

    public List<Organization> getOrganizations() {
        return this.organizations;
    }

    private List<RoleMapping> getRoleMappings() {
        return this.roleMappings;
    }

    public void map(Group group, Role role) {
        this.getRoleMappings().add(new RoleMapping(group, role));
    }

    public void map(Organization organization, Role role) {
        this.getRoleMappings().add(new RoleMapping(organization, role));
    }

    public void map(User user, Role role) {
        this.getRoleMappings().add(new RoleMapping(user, role));
    }

    public synchronized void setOrganizations(List<Organization> organizations) {
        this.organizations.clear();
        if (organizations != null) {
            this.organizations.addAll(organizations);
        }
    }

    public void setRoleMappings(List<RoleMapping> roleMappings) {
        this.roleMappings.clear();
        if (roleMappings != null) {
            this.roleMappings.addAll(roleMappings);
        }
    }

    public void unmap(Group group, Role role) {
        this.unmap((Object)group, role);
    }

    private void unmap(Object source, Role role) {
        for (int i = this.getRoleMappings().size(); i >= 0; --i) {
            RoleMapping mapping = this.getRoleMappings().get(i);
            if (!mapping.getSource().equals(source) || !mapping.getTarget().equals(role)) continue;
            this.getRoleMappings().remove(i);
        }
    }

    public void unmap(Organization organization, Role role) {
        this.unmap((Object)organization, role);
    }

    public void unmap(User user, Role role) {
        this.unmap((Object)user, role);
    }

    private class DefaultVerifier
    extends LocalVerifier {
        private DefaultVerifier() {
        }

        protected char[] getSecret(String identifier) {
            char[] result = null;
            User user = MemoryRealm.this.findUser(identifier);
            if (user != null) {
                result = user.getSecret();
            }
            return result;
        }
    }

    private class DefaultEnroler
    extends Enroler {
        private DefaultEnroler() {
        }

        public void enrole(Subject subject) {
            Set<UserPrincipal> userPrincipals = subject.getPrincipals(UserPrincipal.class);
            for (UserPrincipal userPrincipal : userPrincipals) {
                Organization orga = MemoryRealm.this.findUserOrganization(userPrincipal.getName());
                User user = MemoryRealm.this.findUser(orga, userPrincipal.getName());
                if (user == null) continue;
                Set<Group> userGroups = orga.findGroups(user);
                Set<Role> userRoles = MemoryRealm.this.findRoles(orga, userGroups, user);
                for (Role role : userRoles) {
                    subject.getPrincipals().add(new RolePrincipal(role));
                }
            }
        }
    }
}

