/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.restlet.Restlet;
import org.restlet.data.Cookie;
import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.routing.Filter;
import org.restlet.routing.Router;
import org.restlet.util.Series;
import org.restlet.util.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route
extends Filter {
    private volatile List<ExtractInfo> cookieExtracts;
    private volatile List<ExtractInfo> entityExtracts;
    private volatile boolean matchQuery;
    private volatile List<ExtractInfo> queryExtracts;
    private volatile Router router;
    private volatile Template template;
    private volatile List<ValidateInfo> validations;

    public Route(Restlet next) {
        this(null, (Template)null, next);
    }

    public Route(Router router, String uriTemplate, Restlet next) {
        this(router, new Template(uriTemplate, 1, 10, "", true, false), next);
    }

    public Route(Router router, Template template, Restlet next) {
        super(router == null ? null : router.getContext(), next);
        this.matchQuery = router == null ? true : router.getDefaultMatchQuery();
        this.router = router;
        this.template = template;
    }

    @Override
    protected int beforeHandle(Request request, Response response) {
        if (this.getTemplate() != null) {
            String remainingPart = request.getResourceRef().getRemainingPart(false, this.getMatchQuery());
            int matchedLength = this.getTemplate().parse(remainingPart, request);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("Attempting to match this pattern: " + this.getTemplate().getPattern() + " >> " + matchedLength);
            }
            if (matchedLength != -1) {
                String matchedPart = remainingPart.substring(0, matchedLength);
                Reference baseRef = request.getResourceRef().getBaseRef();
                baseRef = baseRef == null ? new Reference(matchedPart) : new Reference(baseRef.toString(false, false) + matchedPart);
                request.getResourceRef().setBaseRef(baseRef);
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine("New base URI: " + request.getResourceRef().getBaseRef());
                    this.getLogger().fine("New remaining part: " + request.getResourceRef().getRemainingPart(false, this.getMatchQuery()));
                }
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine("Delegating the call to the target Restlet");
                }
            } else {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        this.extractAttributes(request, response);
        this.validateAttributes(request, response);
        return 0;
    }

    private void extractAttributes(Request request, Response response) {
        Series<Cookie> cookies;
        Form form;
        if (!this.getQueryExtracts().isEmpty() && (form = request.getResourceRef().getQueryAsForm()) != null) {
            for (ExtractInfo ei : this.getQueryExtracts()) {
                if (ei.first) {
                    request.getAttributes().put(ei.attribute, form.getFirstValue(ei.parameter));
                    continue;
                }
                request.getAttributes().put(ei.attribute, form.subList(ei.parameter));
            }
        }
        if (!this.getEntityExtracts().isEmpty() && (form = request.getEntityAsForm()) != null) {
            for (ExtractInfo ei : this.getEntityExtracts()) {
                if (ei.first) {
                    request.getAttributes().put(ei.attribute, form.getFirstValue(ei.parameter));
                    continue;
                }
                request.getAttributes().put(ei.attribute, form.subList(ei.parameter));
            }
        }
        if (!this.getCookieExtracts().isEmpty() && (cookies = request.getCookies()) != null) {
            for (ExtractInfo ei : this.getCookieExtracts()) {
                if (ei.first) {
                    request.getAttributes().put(ei.attribute, cookies.getFirstValue(ei.parameter));
                    continue;
                }
                request.getAttributes().put(ei.attribute, cookies.subList(ei.parameter));
            }
        }
    }

    public Route extractCookie(String attribute, String cookieName, boolean first) {
        this.getCookieExtracts().add(new ExtractInfo(attribute, cookieName, first));
        return this;
    }

    public Route extractEntity(String attribute, String parameter, boolean first) {
        this.getEntityExtracts().add(new ExtractInfo(attribute, parameter, first));
        return this;
    }

    public Route extractQuery(String attribute, String parameter, boolean first) {
        this.getQueryExtracts().add(new ExtractInfo(attribute, parameter, first));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtractInfo> getCookieExtracts() {
        List<ExtractInfo> ce = this.cookieExtracts;
        if (ce == null) {
            Route route = this;
            synchronized (route) {
                ce = this.cookieExtracts;
                if (ce == null) {
                    this.cookieExtracts = ce = new CopyOnWriteArrayList<ExtractInfo>();
                }
            }
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtractInfo> getEntityExtracts() {
        List<ExtractInfo> ee = this.entityExtracts;
        if (ee == null) {
            Route route = this;
            synchronized (route) {
                ee = this.entityExtracts;
                if (ee == null) {
                    this.entityExtracts = ee = new CopyOnWriteArrayList<ExtractInfo>();
                }
            }
        }
        return ee;
    }

    public int getMatchingMode() {
        return this.getTemplate().getMatchingMode();
    }

    public boolean getMatchQuery() {
        return this.matchQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtractInfo> getQueryExtracts() {
        List<ExtractInfo> qe = this.queryExtracts;
        if (qe == null) {
            Route route = this;
            synchronized (route) {
                qe = this.queryExtracts;
                if (qe == null) {
                    this.queryExtracts = qe = new CopyOnWriteArrayList<ExtractInfo>();
                }
            }
        }
        return qe;
    }

    public Router getRouter() {
        return this.router;
    }

    public Template getTemplate() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValidateInfo> getValidations() {
        List<ValidateInfo> v = this.validations;
        if (v == null) {
            Route route = this;
            synchronized (route) {
                v = this.validations;
                if (v == null) {
                    this.validations = v = new CopyOnWriteArrayList<ValidateInfo>();
                }
            }
        }
        return v;
    }

    public float score(Request request, Response response) {
        float result = 0.0f;
        if (this.getRouter() != null && request.getResourceRef() != null && this.getTemplate() != null) {
            int matchedLength;
            String remainingPart = request.getResourceRef().getRemainingPart(false, this.getMatchQuery());
            if (remainingPart != null && (matchedLength = this.getTemplate().match(remainingPart)) != -1) {
                float totalLength = remainingPart.length();
                result = totalLength > 0.0f ? this.getRouter().getRequiredScore() + (1.0f - this.getRouter().getRequiredScore()) * ((float)matchedLength / totalLength) : 1.0f;
            }
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("Call score for the \"" + this.getTemplate().getPattern() + "\" URI pattern: " + result);
            }
        }
        return result;
    }

    public void setMatchingMode(int matchingMode) {
        this.getTemplate().setMatchingMode(matchingMode);
    }

    public void setMatchQuery(boolean matchQuery) {
        this.matchQuery = matchQuery;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public void validate(String attribute, boolean required, String format) {
        this.getValidations().add(new ValidateInfo(attribute, required, format));
    }

    private void validateAttributes(Request request, Response response) {
        if (this.validations != null) {
            for (ValidateInfo validate : this.getValidations()) {
                if (validate.required && !request.getAttributes().containsKey(validate.attribute)) {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to find the \"" + validate.attribute + "\" attribute in the request. Please check your request.");
                    continue;
                }
                if (validate.format == null) continue;
                Object value = request.getAttributes().get(validate.attribute);
                if (value == null) {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to validate the \"" + validate.attribute + "\" attribute with a null value. Please check your request.");
                    continue;
                }
                if (Pattern.matches(validate.format, value.toString())) continue;
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to validate the value of the \"" + validate.attribute + "\" attribute. The expected format is: " + validate.format + " (Java Regex). Please check your request.");
            }
        }
    }

    private static final class ValidateInfo {
        protected String attribute;
        protected String format;
        protected boolean required;

        public ValidateInfo(String attribute, boolean required, String format) {
            this.attribute = attribute;
            this.required = required;
            this.format = format;
        }
    }

    private static final class ExtractInfo {
        protected String attribute;
        protected boolean first;
        protected String parameter;

        public ExtractInfo(String attribute, String parameter, boolean first) {
            this.attribute = attribute;
            this.parameter = parameter;
            this.first = first;
        }
    }
}

