/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Uniform;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.UniformResource;
import org.restlet.service.ConverterService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResource
extends UniformResource {
    private volatile boolean followRedirects;
    private volatile Uniform next;

    public static <T> T create(Context context, Reference reference, Class<? extends T> resourceInterface) {
        ClientResource clientResource = new ClientResource(context, reference);
        return clientResource.wrap(resourceInterface);
    }

    public static <T> T create(Reference reference, Class<? extends T> resourceInterface) {
        return ClientResource.create(null, reference, resourceInterface);
    }

    public static <T> T create(String uri, Class<? extends T> resourceInterface) {
        return ClientResource.create(null, new Reference(uri), resourceInterface);
    }

    public ClientResource(Context context, Method method, Reference reference) {
        Request request = new Request(method, reference);
        Response response = new Response(request);
        if (context == null) {
            context = Context.getCurrent();
        }
        if (context != null) {
            this.next = context.getClientDispatcher();
        }
        this.followRedirects = true;
        this.init(context, request, response);
    }

    public ClientResource(Context context, Method method, String uri) {
        this(context, method, new Reference(uri));
    }

    public ClientResource(Context context, Method method, URI uri) {
        this(context, method, new Reference(uri));
    }

    public ClientResource(Context context, Reference reference) {
        this(context, Method.GET, reference);
    }

    public ClientResource(Context context, Request request, Response response) {
        this.followRedirects = true;
        this.init(context, request, response);
    }

    public ClientResource(Context context, String uri) {
        this(context, Method.GET, uri);
    }

    public ClientResource(Context context, URI uri) {
        this(context, Method.GET, uri);
    }

    public ClientResource(Method method, Reference reference) {
        this(Context.getCurrent(), method, reference);
    }

    public ClientResource(Method method, String uri) {
        this(Context.getCurrent(), method, uri);
    }

    public ClientResource(Method method, URI uri) {
        this(Context.getCurrent(), method, uri);
    }

    public ClientResource(Reference reference) {
        this(Context.getCurrent(), null, reference);
    }

    public ClientResource(Request request, Response response) {
        this(Context.getCurrent(), request, response);
    }

    public ClientResource(String uri) {
        this(Context.getCurrent(), null, uri);
    }

    public ClientResource(URI uri) {
        this(Context.getCurrent(), null, uri);
    }

    public Representation delete() throws ResourceException {
        this.setMethod(Method.DELETE);
        return this.handle();
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public Representation get() throws ResourceException {
        this.setMethod(Method.GET);
        return this.handle();
    }

    public <T> T get(Class<T> responseClass) throws ResourceException {
        T result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        ConverterService cs = this.getConverterService();
        List<Variant> variants = cs.getVariants(responseClass, null);
        for (Variant variant : variants) {
            newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(variant.getMediaType()));
        }
        this.setClientInfo(newClientInfo);
        try {
            result = cs.toObject(this.get(), responseClass, this);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation get(MediaType mediaType) throws ResourceException {
        Representation result = null;
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        try {
            result = this.get();
        }
        finally {
            this.setClientInfo(currentClientInfo);
        }
        return result;
    }

    private ConverterService getConverterService() {
        ConverterService cs = null;
        cs = this.getApplication() != null ? this.getApplication().getConverterService() : new ConverterService();
        return cs;
    }

    public Uniform getNext() {
        return this.next;
    }

    @Override
    public Representation handle() {
        Representation result = null;
        if (!this.hasNext()) {
            Protocol protocol;
            Protocol protocol2 = protocol = this.getReference() == null ? null : this.getReference().getSchemeProtocol();
            if (protocol != null) {
                this.setNext(new Client(protocol));
            }
        }
        if (this.hasNext()) {
            this.handle(this.getRequest(), this.getResponse(), null);
            result = this.getResponse().getEntity();
        } else {
            this.getLogger().warning("Unable to process the call for a client resource. No next Restlet has been provided.");
        }
        return result;
    }

    private void handle(Request request, Response response, List<Reference> references) {
        this.getNext().handle(request, response);
        if (request.getMethod().isSafe() && response.getStatus().isRedirection() && response.getLocationRef() != null) {
            Reference newTargetRef = response.getLocationRef();
            if (references != null && references.contains(newTargetRef)) {
                this.getLogger().warning("Infinite redirection loop detected with URI: " + newTargetRef);
            } else if (request.getEntity() != null && !request.isEntityAvailable()) {
                this.getLogger().warning("Unable to follow the redirection because the request entity isn't available anymore.");
            } else {
                if (references == null) {
                    references = new ArrayList<Reference>();
                }
                references.add(request.getResourceRef());
                request.setResourceRef(newTargetRef);
                this.handle(request, response, references);
            }
        }
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public Representation head() throws ResourceException {
        this.setMethod(Method.HEAD);
        return this.handle();
    }

    public Representation head(MediaType mediaType) throws ResourceException {
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        Representation result = this.head();
        this.setClientInfo(currentClientInfo);
        return result;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public Representation options() throws ResourceException {
        this.setMethod(Method.HEAD);
        return this.handle();
    }

    public Representation options(MediaType mediaType) throws ResourceException {
        ClientInfo currentClientInfo = this.getClientInfo();
        ClientInfo newClientInfo = new ClientInfo();
        newClientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(mediaType));
        this.setClientInfo(newClientInfo);
        Representation result = this.options();
        this.setClientInfo(currentClientInfo);
        return result;
    }

    public Representation post(Object entity) throws ResourceException {
        return this.post(this.toRepresentation(entity));
    }

    public <T> T post(Object entity, Class<T> resultClass) throws ResourceException {
        return this.toObject(this.post(this.toRepresentation(entity)), resultClass);
    }

    public Representation post(Representation entity) throws ResourceException {
        this.setMethod(Method.POST);
        this.getRequest().setEntity(entity);
        return this.handle();
    }

    public Representation put(Object entity) throws ResourceException {
        return this.put(this.toRepresentation(entity));
    }

    public <T> T put(Object entity, Class<T> resultClass) throws ResourceException {
        return this.toObject(this.put(this.toRepresentation(entity)), resultClass);
    }

    public Representation put(Representation representation) throws ResourceException {
        this.setMethod(Method.PUT);
        this.getRequest().setEntity(representation);
        return this.handle();
    }

    public void setChallengeResponse(ChallengeResponse challengeResponse) {
        this.getRequest().setChallengeResponse(challengeResponse);
    }

    public void setChallengeResponse(ChallengeScheme scheme, String identifier, String secret) {
        this.setChallengeResponse(new ChallengeResponse(scheme, identifier, secret));
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.getRequest().setClientInfo(clientInfo);
    }

    public void setConditions(Conditions conditions) {
        this.getRequest().setConditions(conditions);
    }

    public void setCookies(Series<Cookie> cookies) {
        this.getRequest().setCookies(cookies);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setHostRef(Reference hostRef) {
        this.getRequest().setHostRef(hostRef);
    }

    public void setHostRef(String hostUri) {
        this.getRequest().setHostRef(hostUri);
    }

    public void setMethod(Method method) {
        this.getRequest().setMethod(method);
    }

    public void setNext(Uniform next) {
        Restlet nextRestlet;
        if (next instanceof Restlet && (nextRestlet = (Restlet)next).getContext() == null) {
            nextRestlet.setContext(this.getContext());
        }
        this.next = next;
    }

    public void setOriginalRef(Reference originalRef) {
        this.getRequest().setOriginalRef(originalRef);
    }

    public void setRanges(List<Range> ranges) {
        this.getRequest().setRanges(ranges);
    }

    public void setReference(Reference resourceRef) {
        this.getRequest().setResourceRef(resourceRef);
    }

    public void setReferrerRef(Reference referrerRef) {
        this.getRequest().setReferrerRef(referrerRef);
    }

    public void setReferrerRef(String referrerUri) {
        this.getRequest().setReferrerRef(referrerUri);
    }

    public void setResourceRef(Reference resourceRef) {
        this.getRequest().setResourceRef(resourceRef);
    }

    public void setResourceRef(String resourceUri) {
        this.getRequest().setResourceRef(resourceUri);
    }

    protected <T> T toObject(Representation sourceRepresentation, Class<T> targetClass) throws ResourceException {
        T result = null;
        if (sourceRepresentation != null) {
            try {
                ConverterService cs = this.getConverterService();
                result = cs.toObject(sourceRepresentation, targetClass, this);
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
        return result;
    }

    protected Representation toRepresentation(Object object) {
        Representation result = null;
        ConverterService cs = this.getConverterService();
        if (this.getClientInfo().getAcceptedMediaTypes().size() > 0) {
            Variant targetVariant = new Variant(this.getClientInfo().getAcceptedMediaTypes().get(0).getMetadata());
            result = cs.toRepresentation(object, targetVariant, null);
        } else {
            result = cs.toRepresentation(object);
        }
        return result;
    }

    public <T> T wrap(Class<? extends T> resourceInterface) {
        final List<AnnotationInfo> annotations = AnnotationUtils.getAnnotationDescriptors(resourceInterface);
        InvocationHandler h = new InvocationHandler(){

            public Object invoke(Object proxy, java.lang.reflect.Method javaMethod, Object[] args) throws Throwable {
                Object result = null;
                AnnotationInfo annotation = AnnotationUtils.getAnnotation((List<AnnotationInfo>)annotations, javaMethod);
                if (annotation != null) {
                    ClientResource.this.setMethod(annotation.getRestletMethod());
                    if (args != null && args.length > 0) {
                        Representation entity = ClientResource.this.toRepresentation(args[0]);
                        ClientResource.this.getRequest().setEntity(entity);
                    }
                    ClientResource.this.handle();
                    if (annotation.getJavaReturnType() != null) {
                        result = ClientResource.this.toObject(ClientResource.this.getResponseEntity(), annotation.getJavaReturnType());
                    }
                }
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(Engine.getClassLoader(), new Class[]{resourceInterface}, h);
    }
}

