/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variant {
    private volatile CharacterSet characterSet = null;
    private volatile List<Encoding> encodings = null;
    private volatile Reference identifier;
    private volatile List<Language> languages = null;
    private volatile MediaType mediaType;

    public Variant() {
        this(null);
    }

    public Variant(MediaType mediaType) {
        this.mediaType = mediaType;
        this.identifier = null;
    }

    public ClientInfo createClientInfo() {
        ClientInfo result = new ClientInfo();
        if (this.getCharacterSet() != null) {
            result.getAcceptedCharacterSets().add(new Preference<CharacterSet>(this.getCharacterSet()));
        }
        if (this.getEncodings() != null) {
            for (Encoding encoding : this.getEncodings()) {
                result.getAcceptedEncodings().add(new Preference<Encoding>(encoding));
            }
        }
        if (this.getLanguages() != null) {
            for (Language language : this.getLanguages()) {
                result.getAcceptedLanguages().add(new Preference<Language>(language));
            }
        }
        if (this.getMediaType() != null) {
            result.getAcceptedMediaTypes().add(new Preference<MediaType>(this.getMediaType()));
        }
        return result;
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public List<Encoding> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new WrapperList<Encoding>(){

                @Override
                public boolean add(Encoding element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.add(element);
                }

                @Override
                public void add(int index, Encoding element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    super.add(index, element);
                }

                @Override
                public boolean addAll(Collection<? extends Encoding> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Encoding> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.addAll(elements);
                }

                @Override
                public boolean addAll(int index, Collection<? extends Encoding> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Encoding> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null encoding.");
                    }
                    return super.addAll(index, elements);
                }
            };
        }
        return this.encodings;
    }

    public Reference getIdentifier() {
        return this.identifier;
    }

    public List<Language> getLanguages() {
        if (this.languages == null) {
            this.languages = new WrapperList<Language>(){

                @Override
                public void add(int index, Language element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    super.add(index, element);
                }

                @Override
                public boolean add(Language element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.add(element);
                }

                @Override
                public boolean addAll(Collection<? extends Language> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Language> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.addAll(elements);
                }

                @Override
                public boolean addAll(int index, Collection<? extends Language> elements) {
                    boolean addNull;
                    boolean bl = addNull = elements == null;
                    if (!addNull) {
                        Iterator<? extends Language> iterator = elements.iterator();
                        while (!addNull && iterator.hasNext()) {
                            addNull = iterator.next() == null;
                        }
                    }
                    if (addNull) {
                        throw new IllegalArgumentException("Cannot add a null language.");
                    }
                    return super.addAll(index, elements);
                }
            };
        }
        return this.languages;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setCharacterSet(CharacterSet characterSet) {
        this.characterSet = characterSet;
    }

    public void setEncodings(List<Encoding> encodings) {
        this.encodings = encodings;
    }

    public void setIdentifier(Reference identifier) {
        this.identifier = identifier;
    }

    public void setIdentifier(String identifierUri) {
        this.setIdentifier(new Reference(identifierUri));
    }

    public void setLanguages(List<Language> languages) {
        this.languages = languages;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public boolean isCompatible(Variant other) {
        boolean result = true;
        if (result) {
            boolean bl = result = this.getCharacterSet() == null || this.getCharacterSet().equals(CharacterSet.ALL) || this.getCharacterSet().equals(other.getCharacterSet());
        }
        if (result) {
            boolean bl = result = this.getMediaType() == null || this.getMediaType().isCompatible(other.getMediaType());
        }
        if (result) {
            result = this.getLanguages().isEmpty() || this.getLanguages().contains(Language.ALL) || this.getLanguages().containsAll(other.getLanguages());
        }
        return result;
    }
}

