/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Digest;
import org.restlet.data.MediaType;
import org.restlet.data.Range;
import org.restlet.data.Tag;
import org.restlet.engine.io.ByteUtils;
import org.restlet.engine.util.DateUtils;
import org.restlet.representation.DigesterRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.RepresentationInfo;
import org.restlet.representation.Variant;

public abstract class Representation
extends RepresentationInfo {
    public static final long UNKNOWN_SIZE = -1L;
    private volatile boolean available;
    private volatile Digest digest;
    private volatile boolean downloadable;
    private volatile String downloadName;
    private volatile Date expirationDate;
    private volatile boolean isTransient;
    private volatile Range range;
    private volatile long size;

    @Deprecated
    public static Representation createEmpty() {
        return new EmptyRepresentation();
    }

    public Representation() {
        this(null);
    }

    public Representation(MediaType mediaType) {
        super(mediaType);
        this.available = true;
        this.digest = null;
        this.downloadable = false;
        this.downloadName = null;
        this.isTransient = false;
        this.range = null;
        this.size = -1L;
        this.expirationDate = null;
    }

    public Representation(MediaType mediaType, Date modificationDate) {
        this(mediaType, modificationDate, null);
    }

    public Representation(MediaType mediaType, Date modificationDate, Tag tag) {
        super(mediaType, modificationDate, tag);
    }

    public Representation(MediaType mediaType, Tag tag) {
        this(mediaType, null, tag);
    }

    public Representation(Variant variant, Date modificationDate) {
        this(variant, modificationDate, null);
    }

    public Representation(Variant variant, Date modificationDate, Tag tag) {
        this.setCharacterSet(variant.getCharacterSet());
        this.setEncodings(variant.getEncodings());
        this.setIdentifier(variant.getIdentifier());
        this.setLanguages(variant.getLanguages());
        this.setMediaType(variant.getMediaType());
        this.setModificationDate(modificationDate);
        this.setTag(tag);
    }

    public Representation(Variant variant, Tag tag) {
        this(variant, null, tag);
    }

    @Deprecated
    public boolean checkDigest() {
        return this.getDigest() != null && this.checkDigest(this.getDigest().getAlgorithm());
    }

    @Deprecated
    public boolean checkDigest(String algorithm) {
        Digest digest = this.getDigest();
        if (digest != null && algorithm.equals(digest.getAlgorithm())) {
            return digest.equals(this.computeDigest(algorithm));
        }
        return false;
    }

    @Deprecated
    public Digest computeDigest(String algorithm) {
        Digest result = null;
        if (this.isAvailable()) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                DigestInputStream dis = new DigestInputStream(this.getStream(), md);
                ByteUtils.exhaust(dis);
                result = new Digest(algorithm, md.digest());
            }
            catch (NoSuchAlgorithmException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to check the digest of the representation.", e);
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to check the digest of the representation.", e);
            }
        }
        return result;
    }

    public long exhaust() throws IOException {
        long result = -1L;
        if (this.isAvailable()) {
            result = ByteUtils.exhaust(this.getStream());
        }
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public long getAvailableSize() {
        if (this.getRange() == null) {
            return this.getSize();
        }
        if (this.getRange().getSize() != -1L) {
            return this.getRange().getSize();
        }
        if (this.getSize() != -1L) {
            if (this.getRange().getIndex() != -1L) {
                return this.getSize() - this.getRange().getIndex();
            }
            return this.getSize();
        }
        return -1L;
    }

    public abstract ReadableByteChannel getChannel() throws IOException;

    public Digest getDigest() {
        return this.digest;
    }

    public DigesterRepresentation getDigester() {
        DigesterRepresentation result = null;
        try {
            result = new DigesterRepresentation(this);
        }
        catch (NoSuchAlgorithmException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to get the digester representation", e);
        }
        return result;
    }

    public DigesterRepresentation getDigester(String algorithm) {
        DigesterRepresentation result = null;
        try {
            result = new DigesterRepresentation(this, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to get the digester representation", e);
        }
        return result;
    }

    public String getDownloadName() {
        return this.downloadName;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public Range getRange() {
        return this.range;
    }

    public abstract Reader getReader() throws IOException;

    public long getSize() {
        return this.size;
    }

    public abstract InputStream getStream() throws IOException;

    public String getText() throws IOException {
        String result = null;
        if (this.isAvailable()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(baos);
            result = this.getCharacterSet() != null ? baos.toString(this.getCharacterSet().getName()) : baos.toString();
        }
        return result;
    }

    public boolean isAvailable() {
        return this.getSize() != 0L && this.available;
    }

    public boolean isDownloadable() {
        return this.downloadable;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void release() {
        this.available = false;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setDigest(Digest digest) {
        this.digest = digest;
    }

    public void setDownloadable(boolean downloadable) {
        this.downloadable = downloadable;
    }

    public void setDownloadName(String fileName) {
        this.downloadName = fileName;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = DateUtils.unmodifiable(expirationDate);
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setSize(long expectedSize) {
        this.size = expectedSize;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public abstract void write(OutputStream var1) throws IOException;

    public abstract void write(WritableByteChannel var1) throws IOException;

    public abstract void write(Writer var1) throws IOException;
}

