/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.ClientInfo;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.representation.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnegUtils {
    public static Variant getPreferredVariant(ClientInfo client, List<Variant> variants, Language defaultLanguage) {
        Language language;
        ArrayList<Preference<Language>> list;
        if (variants == null) {
            return null;
        }
        List<Language> variantLanguages = null;
        MediaType variantMediaType = null;
        boolean compatibleLanguage = false;
        boolean compatibleMediaType = false;
        Variant currentVariant2 = null;
        Variant bestVariant = null;
        Preference<Language> currentLanguagePref = null;
        Preference<Language> bestLanguagePref = null;
        Preference<MediaType> currentMediaTypePref = null;
        Preference<MediaType> bestMediaTypePref = null;
        float bestQuality = 0.0f;
        float bestLanguageScore = 0.0f;
        float bestMediaTypeScore = 0.0f;
        List<Preference<Language>> languagePrefs = client.getAcceptedLanguages();
        ArrayList<Preference<Language>> primaryLanguagePrefs = new ArrayList<Preference<Language>>();
        Preference<Language> defaultLanguagePref = defaultLanguage == null ? null : new Preference<Language>(defaultLanguage, 0.003f);
        Preference<Language> allLanguagesPref = new Preference<Language>(Language.ALL, 0.001f);
        if (languagePrefs.isEmpty()) {
            languagePrefs.add(new Preference<Language>(Language.ALL));
        } else {
            list = new ArrayList<Preference<Language>>();
            for (Preference<Language> preference : languagePrefs) {
                language = preference.getMetadata();
                if (language.getSubTags().isEmpty() || list.contains(language.getPrimaryTag())) continue;
                list.add((Preference<Language>)((Object)language.getPrimaryTag()));
                primaryLanguagePrefs.add(new Preference<Language>(new Language(language.getPrimaryTag()), 0.005f + 0.001f * preference.getQuality()));
            }
            if (defaultLanguage != null && !defaultLanguage.getSubTags().isEmpty() && !list.contains(defaultLanguage.getPrimaryTag())) {
                primaryLanguagePrefs.add(new Preference<Language>(new Language(defaultLanguage.getPrimaryTag()), 0.002f));
            }
        }
        languagePrefs.addAll(primaryLanguagePrefs);
        if (defaultLanguagePref != null) {
            languagePrefs.add(defaultLanguagePref);
            list = new ArrayList();
            for (Preference<Language> preference : languagePrefs) {
                language = preference.getMetadata();
                if (language.equals(Language.ALL)) continue;
                list.add(preference);
            }
            languagePrefs = list;
        }
        languagePrefs.add(allLanguagesPref);
        for (Variant currentVariant2 : variants) {
            variantLanguages = currentVariant2.getLanguages();
            variantMediaType = currentVariant2.getMediaType();
            for (Language variantLanguage : variantLanguages) {
                Iterator<Preference<Language>> iter2 = languagePrefs.iterator();
                while (variantLanguage != null && iter2.hasNext()) {
                    currentLanguagePref = iter2.next();
                    float currentScore = ConnegUtils.getScore(variantLanguage, currentLanguagePref.getMetadata());
                    boolean compatiblePref = currentScore != -1.0f;
                    if (!compatiblePref || bestLanguagePref != null && !(currentScore > bestLanguageScore)) continue;
                    bestLanguagePref = currentLanguagePref;
                    bestLanguageScore = currentScore;
                }
            }
            compatibleLanguage = variantLanguages.isEmpty() || bestLanguagePref != null;
            List<Preference<MediaType>> mediaTypePrefs = client.getAcceptedMediaTypes();
            if (mediaTypePrefs.size() == 0) {
                mediaTypePrefs.add(new Preference<MediaType>(MediaType.ALL));
            }
            Iterator<Preference<MediaType>> iter2 = mediaTypePrefs.iterator();
            while (compatibleLanguage && iter2.hasNext()) {
                currentMediaTypePref = iter2.next();
                float currentScore = ConnegUtils.getScore(variantMediaType, currentMediaTypePref.getMetadata());
                boolean compatiblePref = currentScore != -1.0f;
                if (!compatiblePref || bestMediaTypePref != null && !(currentScore > bestMediaTypeScore)) continue;
                bestMediaTypePref = currentMediaTypePref;
                bestMediaTypeScore = currentScore;
            }
            boolean bl = compatibleMediaType = variantMediaType == null || bestMediaTypePref != null;
            if (compatibleLanguage && compatibleMediaType) {
                float currentQuality = 0.0f;
                if (bestLanguagePref != null) {
                    currentQuality += bestLanguagePref.getQuality() * 10.0f;
                } else if (!variantLanguages.isEmpty()) {
                    currentQuality += 1.0f;
                }
                if (bestMediaTypePref != null) {
                    currentQuality += bestMediaTypePref.getQuality();
                }
                if (bestVariant == null) {
                    bestVariant = currentVariant2;
                    bestQuality = currentQuality;
                } else if (currentQuality > bestQuality) {
                    bestVariant = currentVariant2;
                    bestQuality = currentQuality;
                }
            }
            bestLanguagePref = null;
            bestLanguageScore = 0.0f;
            bestMediaTypePref = null;
            bestMediaTypeScore = 0.0f;
        }
        return bestVariant;
    }

    public static float getScore(Language variantLanguage, Language preferenceLanguage) {
        float score = 0.0f;
        boolean compatibleLang = true;
        if (variantLanguage.getPrimaryTag().equalsIgnoreCase(preferenceLanguage.getPrimaryTag())) {
            score += 100.0f;
        } else if (!preferenceLanguage.getPrimaryTag().equals("*")) {
            compatibleLang = false;
        } else if (!preferenceLanguage.getSubTags().isEmpty()) {
            compatibleLang = false;
        } else {
            score += 1.0f;
        }
        if (compatibleLang) {
            if (preferenceLanguage.getSubTags().isEmpty() || variantLanguage.getSubTags().isEmpty()) {
                if (variantLanguage.getSubTags().isEmpty() && preferenceLanguage.getSubTags().isEmpty()) {
                    score += 10.0f;
                }
            } else {
                int maxSize = Math.min(preferenceLanguage.getSubTags().size(), variantLanguage.getSubTags().size());
                for (int i = 0; i < maxSize && compatibleLang; ++i) {
                    if (preferenceLanguage.getSubTags().get(i).equalsIgnoreCase(variantLanguage.getSubTags().get(i))) {
                        score = (float)((double)score + Math.pow(10.0, 1 - i));
                        continue;
                    }
                    compatibleLang = false;
                }
            }
        }
        return compatibleLang ? score : -1.0f;
    }

    public static float getScore(MediaType variantMediaType, MediaType preferenceMediaType) {
        float score = 0.0f;
        boolean comptabibleMediaType = true;
        if (preferenceMediaType.getMainType().equals(variantMediaType.getMainType())) {
            score += 1000.0f;
        } else if (!preferenceMediaType.getMainType().equals("*")) {
            comptabibleMediaType = false;
        } else if (!preferenceMediaType.getSubType().equals("*")) {
            comptabibleMediaType = false;
        }
        if (comptabibleMediaType) {
            if (variantMediaType.getSubType().equals(preferenceMediaType.getSubType())) {
                score += 100.0f;
            } else if (!preferenceMediaType.getSubType().equals("*")) {
                comptabibleMediaType = false;
            }
            if (comptabibleMediaType && variantMediaType.getParameters() != null) {
                for (Parameter currentParam : variantMediaType.getParameters()) {
                    if (!preferenceMediaType.getParameters().contains(currentParam)) continue;
                    score += 1.0f;
                }
            }
        }
        return comptabibleMediaType ? score : -1.0f;
    }

    private ConnegUtils() {
    }
}

