/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.restlet.engine.util.Base64;

public class CryptoUtils {
    protected static Cipher createCipher(String algo, String base64Secret, int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(algo);
        cipher.init(mode, new SecretKeySpec(Base64.decode(base64Secret), algo));
        return cipher;
    }

    public static String decrypt(String algo, String base64Secret, byte[] encrypted) throws GeneralSecurityException {
        byte[] original = CryptoUtils.doFinal(algo, base64Secret, 2, encrypted);
        return new String(original);
    }

    protected static byte[] doFinal(String algo, String base64Secret, int mode, byte[] what) throws GeneralSecurityException {
        return CryptoUtils.createCipher(algo, base64Secret, mode).doFinal(what);
    }

    public static byte[] encrypt(String algo, String base64Secret, String content) throws GeneralSecurityException {
        return CryptoUtils.doFinal(algo, base64Secret, 1, content.getBytes());
    }

    private CryptoUtils() {
    }
}

