/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.restlet.data.MediaType;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.ZipEntryRepresentation;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntryEntity
extends Entity {
    protected final ZipFile zipFile;
    protected final ZipEntry entry;

    public ZipEntryEntity(ZipFile zipFile, String entryName) {
        ZipEntry entryDir;
        this.zipFile = zipFile;
        ZipEntry entry = zipFile.getEntry(entryName);
        this.entry = entry == null ? new ZipEntry(entryName) : ((entryDir = zipFile.getEntry(entryName + "/")) != null ? entryDir : entry);
    }

    public ZipEntryEntity(ZipFile zipFile, ZipEntry entry) {
        this.zipFile = zipFile;
        this.entry = entry;
    }

    @Override
    public boolean exists() {
        if ("".equals(this.getName())) {
            return true;
        }
        return this.entry.getSize() != -1L;
    }

    @Override
    public List<Entity> getChildren() {
        ArrayList<ZipEntryEntity> result = null;
        if (this.isDirectory()) {
            result = new ArrayList<ZipEntryEntity>();
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            String n = this.entry.getName();
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                if (!e.getName().startsWith(n) || e.getName().length() == n.length()) continue;
                result.add(new ZipEntryEntity(this.zipFile, e));
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public Entity getParent() {
        if ("".equals(this.entry.getName())) {
            return null;
        }
        String n = this.entry.getName();
        String pn = n.substring(0, n.lastIndexOf(47) + 1);
        return new ZipEntryEntity(this.zipFile, this.zipFile.getEntry(pn));
    }

    @Override
    public Representation getRepresentation(MediaType defaultMediaType, int timeToLive) {
        return new ZipEntryRepresentation(defaultMediaType, this.zipFile, this.entry);
    }

    @Override
    public boolean isDirectory() {
        if ("".equals(this.entry.getName())) {
            return true;
        }
        return this.entry.isDirectory();
    }

    @Override
    public boolean isNormal() {
        return !this.entry.isDirectory();
    }
}

