/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.restlet.Client;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.engine.io.ByteUtils;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.LocalClientHelper;
import org.restlet.engine.local.ZipEntryEntity;
import org.restlet.representation.Representation;
import org.restlet.service.MetadataService;

public class ZipClientHelper
extends LocalClientHelper {
    public ZipClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.ZIP);
        this.getProtocols().add(Protocol.JAR);
    }

    public void handle(Request request, Response response) {
        request.getResourceRef().normalize();
        String path = request.getResourceRef().getHierarchicalPart();
        String decodedPath = Reference.decode(path);
        MetadataService metadataService = this.getMetadataService(request);
        this.handleEntity(request, response, path, decodedPath, metadataService);
    }

    protected void handleEntity(Request request, Response response, String path, String decodedPath, MetadataService metadataService) {
        String entryName;
        String fileUri;
        int spi = decodedPath.indexOf("!/");
        if (spi != -1) {
            fileUri = decodedPath.substring(0, spi);
            entryName = decodedPath.substring(spi + 2);
        } else {
            fileUri = decodedPath;
            entryName = "";
        }
        LocalReference fileRef = new LocalReference(fileUri);
        if (Protocol.FILE.equals(fileRef.getSchemeProtocol())) {
            File file = fileRef.getFile();
            if (Method.GET.equals(request.getMethod()) || Method.HEAD.equals(request.getMethod())) {
                this.handleGet(request, response, file, entryName, metadataService);
            } else if (Method.PUT.equals(request.getMethod())) {
                this.handlePut(request, response, file, entryName);
            } else {
                response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                response.getAllowedMethods().add(Method.GET);
                response.getAllowedMethods().add(Method.HEAD);
                response.getAllowedMethods().add(Method.PUT);
            }
        } else {
            response.setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED, "Only works on local files.");
        }
    }

    protected void handleGet(Request request, Response response, File file, String entryName, MetadataService metadataService) {
        if (file.exists()) {
            ZipFile zipFile;
            try {
                zipFile = new ZipFile(file);
            }
            catch (Exception e) {
                response.setStatus(Status.SERVER_ERROR_INTERNAL, e);
                return;
            }
            ZipEntryEntity entity = new ZipEntryEntity(zipFile, entryName);
            if (((Entity)entity).exists()) {
                Representation output;
                if (((Entity)entity).isDirectory()) {
                    List<Entity> children = ((Entity)entity).getChildren();
                    ReferenceList rl = new ReferenceList(children.size());
                    String fileUri = LocalReference.createFileReference(file).toString();
                    String scheme = request.getResourceRef().getScheme();
                    String baseUri = scheme + ":" + fileUri + "!/";
                    for (Entity entry : children) {
                        rl.add(baseUri + entry.getName());
                    }
                    output = rl.getTextRepresentation();
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {}
                } else {
                    output = ((Entity)entity).getRepresentation(metadataService.getDefaultMediaType(), this.getTimeToLive());
                    output.setIdentifier(request.getResourceRef());
                    this.updateMetadata(metadataService, ((Entity)entity).getName(), output);
                }
                response.setStatus(Status.SUCCESS_OK);
                response.setEntity(output);
                return;
            }
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
        response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
    }

    private boolean writeEntityStream(Representation entity, ZipOutputStream out, String entryName) throws IOException {
        if (entity != null && !entryName.endsWith("/")) {
            ZipEntry entry = new ZipEntry(entryName);
            if (entity.getModificationDate() != null) {
                entry.setTime(entity.getModificationDate().getTime());
            } else {
                entry.setTime(System.currentTimeMillis());
            }
            out.putNextEntry(entry);
            ByteUtils.write((InputStream)new BufferedInputStream(entity.getStream()), out);
            out.closeEntry();
            return true;
        }
        out.putNextEntry(new ZipEntry(entryName));
        out.closeEntry();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePut(Request request, Response response, File file, String entryName) {
        block39: {
            boolean zipExists = file.exists();
            ZipOutputStream zipOut = null;
            if ("".equals(entryName) && request.getEntity() != null) {
                entryName = request.getEntity().getDownloadName();
            }
            if (entryName == null) {
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Must specify an entry name.");
                return;
            }
            boolean canAppend = !zipExists;
            boolean isDirectory = entryName.endsWith("/");
            boolean wrongReplace = false;
            try {
                if (zipExists) {
                    ZipFile zipFile = new ZipFile(file);
                    canAppend &= null == zipFile.getEntry(entryName);
                    wrongReplace = isDirectory ? null != zipFile.getEntry(entryName.substring(0, entryName.length() - 1)) : null != zipFile.getEntry(entryName + "/");
                    canAppend &= !wrongReplace;
                    zipFile.close();
                }
                Representation entity = isDirectory ? null : request.getEntity();
                if (canAppend) {
                    try {
                        zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        this.writeEntityStream(entity, zipOut, entryName);
                        zipOut.close();
                    }
                    catch (Exception e) {
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, e);
                        return;
                    }
                    finally {
                        if (zipOut != null) {
                            zipOut.close();
                        }
                    }
                    response.setStatus(Status.SUCCESS_CREATED);
                    break block39;
                }
                if (wrongReplace) {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Directory cannot be replace by a file or file by a directory.");
                    break block39;
                }
                File writeTo = null;
                ZipFile zipFile = null;
                try {
                    writeTo = File.createTempFile("restlet_zip_", "zip");
                    zipFile = new ZipFile(file);
                    zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(writeTo)));
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    boolean replaced = false;
                    while (entries.hasMoreElements()) {
                        ZipEntry e = entries.nextElement();
                        if (!replaced && entryName.equals(e.getName())) {
                            this.writeEntityStream(entity, zipOut, entryName);
                            replaced = true;
                            continue;
                        }
                        zipOut.putNextEntry(e);
                        ByteUtils.write((InputStream)new BufferedInputStream(zipFile.getInputStream(e)), zipOut);
                        zipOut.closeEntry();
                    }
                    if (!replaced) {
                        this.writeEntityStream(entity, zipOut, entryName);
                    }
                    zipFile.close();
                    zipOut.close();
                }
                finally {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    finally {
                        if (zipOut != null) {
                            zipOut.close();
                        }
                    }
                }
                if (!file.delete() || !writeTo.renameTo(file)) {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileInputStream fis = null;
                    FileOutputStream fos = null;
                    try {
                        fis = new FileInputStream(writeTo);
                        fos = new FileOutputStream(file);
                        ByteUtils.write((InputStream)fis, fos);
                        response.setStatus(Status.SUCCESS_OK);
                        break block39;
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        finally {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                    }
                }
                response.setStatus(Status.SUCCESS_OK);
            }
            catch (Exception e) {
                response.setStatus(Status.SERVER_ERROR_INTERNAL, e);
                return;
            }
        }
    }
}

