/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.engine.io.ByteUtils;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.EntityClientHelper;
import org.restlet.engine.local.FileEntity;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.service.MetadataService;

public class FileClientHelper
extends EntityClientHelper {
    public FileClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.FILE);
    }

    protected boolean checkExtensionsConsistency(File file, MetadataService metadataService) {
        boolean knownExtension = true;
        Collection<String> set = Entity.getExtensions(file.getName(), metadataService);
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext() && knownExtension) {
            knownExtension = metadataService.getMetadata(iterator.next()) != null;
        }
        return knownExtension;
    }

    private boolean checkMetadataConsistency(String fileName, MetadataService metadataService, Representation representation) {
        boolean result = true;
        if (representation != null) {
            Variant var = new Variant();
            this.updateMetadata(metadataService, fileName, var);
            if (!(var.getLanguages().isEmpty() || representation.getLanguages().isEmpty() || var.getLanguages().containsAll(representation.getLanguages()))) {
                result = false;
            }
            if (var.getMediaType() != null && representation.getMediaType() != null && !var.getMediaType().includes(representation.getMediaType())) {
                result = false;
            }
            if (!(var.getEncodings().isEmpty() || representation.getEncodings().isEmpty() || var.getEncodings().containsAll(representation.getEncodings()))) {
                result = false;
            }
        }
        return result;
    }

    public Entity getEntity(String decodedPath) {
        return new FileEntity(new File(LocalReference.localizePath(decodedPath)));
    }

    public String getTemporaryExtension() {
        return this.getHelpedParameters().getFirstValue("temporaryExtension", "tmp");
    }

    public void handle(Request request, Response response) {
        String scheme = request.getResourceRef().getScheme();
        if (!Protocol.FILE.getSchemeName().equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only FILE is supported.");
        }
        super.handle(request, response);
    }

    protected void handleEntity(Request request, Response response, String path, String decodedPath, MetadataService metadataService) {
        if (Method.GET.equals(request.getMethod()) || Method.HEAD.equals(request.getMethod())) {
            this.handleEntityGet(request, response, path, this.getEntity(decodedPath), metadataService);
        } else if (Method.PUT.equals(request.getMethod())) {
            this.handleFilePut(request, response, decodedPath, new File(decodedPath), metadataService);
        } else if (Method.DELETE.equals(request.getMethod())) {
            this.handleFileDelete(response, new File(decodedPath));
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
            response.getAllowedMethods().add(Method.PUT);
            response.getAllowedMethods().add(Method.DELETE);
        }
    }

    protected void handleFileDelete(Response response, File file) {
        if (file.isDirectory()) {
            if (file.listFiles().length == 0) {
                if (file.delete()) {
                    response.setStatus(Status.SUCCESS_NO_CONTENT);
                } else {
                    response.setStatus(Status.SERVER_ERROR_INTERNAL, "Couldn't delete the directory");
                }
            } else {
                response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, "Couldn't delete the non-empty directory");
            }
        } else if (file.delete()) {
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL, "Couldn't delete the file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void handleFilePut(Request request, Response response, String path, File file, MetadataService metadataService) {
        isDirectory = false;
        if (file.exists()) {
            if (file.isDirectory()) {
                isDirectory = true;
                response.setStatus(new Status(Status.CLIENT_ERROR_FORBIDDEN, "Can't put a new representation of a directory"));
                return;
            }
        } else if (path.endsWith("/")) {
            isDirectory = true;
            if (file.mkdirs()) {
                response.setStatus(Status.SUCCESS_NO_CONTENT);
            } else {
                this.getLogger().log(Level.WARNING, "Unable to create the new directory");
                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new directory"));
            }
            return;
        }
        if (!isDirectory) {
            v0 = partialPut = request.getRanges().isEmpty() == false;
            if (!this.checkMetadataConsistency(file.getName(), metadataService, request.getEntity())) {
                response.setStatus(new Status(Status.REDIRECTION_SEE_OTHER, "The metadata are not consistent with the URI"));
                return;
            }
            baseName = Entity.getBaseName(file.getName(), metadataService);
            extensions = Entity.getExtensions(file.getName(), metadataService);
            files = file.getParentFile().listFiles();
            uniqueVariant = null;
            variantsList = new ArrayList<File>();
            if (files != null) {
                for (File entry : files) {
                    if (!baseName.equals(Entity.getBaseName(entry.getName(), metadataService)) || !(entryExtensions = Entity.getExtensions(entry.getName(), metadataService)).containsAll(extensions)) continue;
                    variantsList.add(entry);
                    if (!extensions.containsAll(entryExtensions)) continue;
                    uniqueVariant = entry;
                }
            }
            if (uniqueVariant != null) {
                file = uniqueVariant;
            } else {
                if (!variantsList.isEmpty()) {
                    response.setStatus(new Status(Status.CLIENT_ERROR_NOT_ACCEPTABLE, "Unable to process properly the request. Several variants exist but none of them suits precisely."));
                    return;
                }
                this.updateMetadata(metadataService, file.getName(), request.getEntity());
                if (request.getEntity().getLanguages().isEmpty() && metadataService.getDefaultLanguage() != null) {
                    request.getEntity().getLanguages().add(metadataService.getDefaultLanguage());
                }
                if (request.getEntity().getMediaType() == null) {
                    request.getEntity().setMediaType(metadataService.getDefaultMediaType());
                }
                if (request.getEntity().getEncodings().isEmpty() && metadataService.getDefaultEncoding() != null && !metadataService.getDefaultEncoding().equals(Encoding.IDENTITY)) {
                    request.getEntity().getEncodings().add(metadataService.getDefaultEncoding());
                }
                fileName = new StringBuilder(baseName);
                if (metadataService.getExtension(request.getEntity().getMediaType()) != null) {
                    fileName.append("." + metadataService.getExtension(request.getEntity().getMediaType()));
                }
                for (Language language : request.getEntity().getLanguages()) {
                    if (metadataService.getExtension(language) == null) continue;
                    fileName.append("." + metadataService.getExtension(language));
                }
                for (Encoding encoding : request.getEntity().getEncodings()) {
                    if (metadataService.getExtension(encoding) == null) continue;
                    fileName.append("." + metadataService.getExtension(encoding));
                }
                file = new File(file.getParentFile(), fileName.toString());
            }
            if (!this.checkExtensionsConsistency(file, metadataService)) {
                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to process properly the URI. At least one extension is not known by the server."));
                return;
            }
            tmp = null;
            error = false;
            if (file.exists()) {
                if (partialPut) {
                    raf = null;
                    try {
                        tmp = new File(file.getCanonicalPath() + "." + this.getTemporaryExtension());
                        range = request.getRanges().get(0);
                        if (tmp.exists() && !this.isResumeUpload()) {
                            tmp.delete();
                        }
                        if (!tmp.exists()) {
                            br = new BufferedReader(new FileReader(file));
                            wr = new BufferedWriter(new FileWriter(tmp));
                            while ((s = br.readLine()) != null) {
                                wr.append(s);
                            }
                            br.close();
                            wr.flush();
                            wr.close();
                        }
                        raf = new RandomAccessFile(tmp, "rwd");
                        if (range.getIndex() == -1L) {
                            if (raf.length() <= range.getSize()) {
                                raf.seek(range.getSize());
                            } else {
                                raf.seek(raf.length() - range.getSize());
                            }
                        } else {
                            raf.seek(range.getIndex());
                        }
                        if (!request.isEntityAvailable()) ** GOTO lbl137
                        ByteUtils.write(request.getEntity().getStream(), raf);
                    }
                    catch (IOException ioe) {
                        this.getLogger().log(Level.WARNING, "Unable to create the temporary file", ioe);
                        response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create a temporary file"));
                        error = true;
                    }
                    finally {
                        try {
                            if (raf != null) {
                                raf.close();
                                System.gc();
                            }
                        }
                        catch (IOException ioe) {
                            this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe);
                            response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe);
                            error = true;
                        }
                    }
                } else {
                    fos = null;
                    try {
                        tmp = File.createTempFile("restlet-upload", "bin");
                        if (request.isEntityAvailable()) {
                            fos = new FileOutputStream(tmp);
                            ByteUtils.write(request.getEntity().getStream(), fos);
                        }
                    }
                    catch (IOException ioe) {
                        this.getLogger().log(Level.WARNING, "Unable to create the temporary file", ioe);
                        response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create a temporary file"));
                        error = true;
                    }
                    finally {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException ioe) {
                            this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe);
                            response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe);
                            error = true;
                        }
                    }
                }
                if (error) {
                    if (tmp.exists() && !this.isResumeUpload()) {
                        tmp.delete();
                    }
                    return;
                }
                if (tmp.exists() && file.delete()) {
                    renameSuccessfull = false;
                    if (tmp.renameTo(file)) {
                        if (request.getEntity() == null) {
                            response.setStatus(Status.SUCCESS_NO_CONTENT);
                        } else {
                            response.setStatus(Status.SUCCESS_OK);
                        }
                        renameSuccessfull = true;
                    } else {
                        if (tmp.exists()) {
                            try {
                                br = new BufferedReader(new FileReader(tmp));
                                wr = new BufferedWriter(new FileWriter(file));
                                while ((s = br.readLine()) != null) {
                                    wr.append(s);
                                }
                                br.close();
                                wr.flush();
                                wr.close();
                                renameSuccessfull = true;
                                tmp.delete();
                            }
                            catch (Exception e) {
                                renameSuccessfull = false;
                            }
                        }
                        if (!renameSuccessfull) {
                            this.getLogger().log(Level.WARNING, "Unable to move the temporary file to replace the existing file");
                            response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to move the temporary file to replace the existing file"));
                        }
                    }
                } else {
                    this.getLogger().log(Level.WARNING, "Unable to delete the existing file");
                    response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to delete the existing file"));
                    if (tmp.exists() && !this.isResumeUpload()) {
                        tmp.delete();
                    }
                }
            } else {
                parent = file.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    this.getLogger().log(Level.WARNING, "Unable to create the parent directory");
                    response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the parent directory"));
                }
                if (partialPut) {
                    raf = null;
                    try {
                        raf = new RandomAccessFile(file, "rwd");
                        range = request.getRanges().get(0);
                        if (range.getIndex() == -1L) {
                            if (raf.length() <= range.getSize()) {
                                raf.seek(range.getSize());
                            } else {
                                raf.seek(raf.length() - range.getSize());
                            }
                        } else {
                            raf.seek(range.getIndex());
                        }
                        if (!request.isEntityAvailable()) ** GOTO lbl246
                        ByteUtils.write(request.getEntity().getStream(), raf);
                    }
                    catch (FileNotFoundException fnfe) {
                        this.getLogger().log(Level.WARNING, "Unable to create the new file", fnfe);
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, fnfe);
                    }
                    catch (IOException ioe) {
                        this.getLogger().log(Level.WARNING, "Unable to create the new file", ioe);
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe);
                    }
                    finally {
                        try {
                            if (raf != null) {
                                raf.close();
                                System.gc();
                            }
                        }
                        catch (IOException ioe) {
                            this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe);
                            response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe);
                        }
                    }
                } else {
                    fos = null;
                    try {
                        if (file.createNewFile()) {
                            if (request.getEntity() == null) {
                                response.setStatus(Status.SUCCESS_NO_CONTENT);
                            } else {
                                fos = new FileOutputStream(file);
                                ByteUtils.write(request.getEntity().getStream(), fos);
                                response.setStatus(Status.SUCCESS_CREATED);
                            }
                        } else {
                            this.getLogger().log(Level.WARNING, "Unable to create the new file");
                            response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new file"));
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        this.getLogger().log(Level.WARNING, "Unable to create the new file", fnfe);
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, fnfe);
                    }
                    catch (IOException ioe) {
                        this.getLogger().log(Level.WARNING, "Unable to create the new file", ioe);
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe);
                    }
                    finally {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException ioe) {
                            this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe);
                            response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe);
                        }
                    }
                }
            }
        }
    }

    public boolean isResumeUpload() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("resumeUpload", "false"));
    }
}

