/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity {
    public static String getBaseName(String name, MetadataService metadataService) {
        String[] result = name.split("\\.");
        StringBuilder baseName = new StringBuilder().append(result[0]);
        boolean extensionFound = false;
        for (int i = 1; i < result.length && !extensionFound; ++i) {
            boolean bl = extensionFound = metadataService.getMetadata(result[i]) != null;
            if (extensionFound) continue;
            baseName.append(".").append(result[i]);
        }
        return baseName.toString();
    }

    public static Collection<String> getExtensions(String name, MetadataService metadataService) {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        String[] tokens = name.split("\\.");
        boolean extensionFound = false;
        for (i = 1; i < tokens.length && !extensionFound; ++i) {
            extensionFound = metadataService.getMetadata(tokens[i]) != null;
        }
        if (extensionFound) {
            --i;
            while (i < tokens.length) {
                result.add(tokens[i]);
                ++i;
            }
        }
        return result;
    }

    public abstract boolean exists();

    public String getBaseName(MetadataService metadataService) {
        return Entity.getBaseName(this.getName(), metadataService);
    }

    public abstract List<Entity> getChildren();

    public Collection<String> getExtensions(MetadataService metadataService) {
        return Entity.getExtensions(this.getName(), metadataService);
    }

    public abstract String getName();

    public abstract Entity getParent();

    public abstract Representation getRepresentation(MediaType var1, int var2);

    public abstract boolean isDirectory();

    public abstract boolean isNormal();
}

