/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.Client;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.engine.http.HttpClientCall;
import org.restlet.engine.http.HttpClientHelper;
import org.restlet.engine.http.StreamClientCall;

public class StreamClientHelper
extends HttpClientHelper {
    public StreamClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTP);
        this.getProtocols().add(Protocol.HTTPS);
    }

    public HttpClientCall create(Request request) {
        return new StreamClientCall(this, request, this.createSocketFactory(request.isConfidential()));
    }

    protected SocketFactory createSecureSocketFactory() throws IOException, GeneralSecurityException {
        String certAlgorithm = this.getCertAlgorithm();
        String keystorePath = this.getKeystorePath();
        String keystorePassword = this.getKeystorePassword();
        String keyPassword = this.getKeyPassword();
        String truststoreType = this.getTruststoreType();
        String truststorePath = this.getTruststorePath();
        String truststorePassword = this.getTruststorePassword();
        String secureRandomAlgorithm = this.getSecureRandomAlgorithm();
        String securityProvider = this.getSecurityProvider();
        FileInputStream keystoreInputStream = null;
        if (keystorePath != null) {
            keystoreInputStream = new FileInputStream(keystorePath);
        }
        KeyStore keystore = KeyStore.getInstance(this.getKeystoreType());
        if (keystoreInputStream != null) {
            try {
                keystore.load(keystoreInputStream, keystorePassword == null ? null : keystorePassword.toCharArray());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to load the keystore", ioe);
                keystore = null;
            }
        }
        KeyManager[] keyManagers = null;
        if (keystore != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(certAlgorithm);
            keyManagerFactory.init(keystore, keyPassword == null ? null : keyPassword.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        FileInputStream truststoreInputStream = null;
        if (truststorePath != null) {
            truststoreInputStream = new FileInputStream(truststorePath);
        }
        KeyStore truststore = null;
        if (truststoreType != null) {
            truststore = KeyStore.getInstance(truststoreType);
            truststore.load(truststoreInputStream, truststorePassword == null ? null : truststorePassword.toCharArray());
        }
        TrustManager[] trustManagers = null;
        if (truststore != null) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(certAlgorithm);
            trustManagerFactory.init(truststore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        SecureRandom secureRandom = secureRandomAlgorithm == null ? null : SecureRandom.getInstance(secureRandomAlgorithm);
        SSLContext context = securityProvider == null ? SSLContext.getInstance(this.getSslProtocol()) : SSLContext.getInstance(this.getSslProtocol(), securityProvider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context.getSocketFactory();
    }

    protected SocketFactory createSocketFactory(boolean secure) {
        SocketFactory result;
        block4: {
            result = null;
            if (secure) {
                try {
                    return this.createSecureSocketFactory();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, "Could not create secure socket factory: " + ex.getMessage(), ex);
                    break block4;
                }
                catch (GeneralSecurityException ex) {
                    this.getLogger().log(Level.SEVERE, "Could not create secure socket factory: " + ex.getMessage(), ex);
                    break block4;
                }
            }
            result = SocketFactory.getDefault();
        }
        return result;
    }

    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", "");
    }

    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", "");
    }

    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    public String getSecureRandomAlgorithm() {
        return this.getHelpedParameters().getFirstValue("secureRandomAlgorithm", null);
    }

    public String getSecurityProvider() {
        return this.getHelpedParameters().getFirstValue("securityProvider", null);
    }

    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public boolean getTcpNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tcpNoDelay", "false"));
    }

    public String getTruststorePassword() {
        return this.getHelpedParameters().getFirstValue("truststorePassword", "");
    }

    public String getTruststorePath() {
        return this.getHelpedParameters().getFirstValue("truststorePath", null);
    }

    public String getTruststoreType() {
        return this.getHelpedParameters().getFirstValue("truststoreType", null);
    }

    public synchronized void start() throws Exception {
        super.start();
        this.getLogger().info("Starting the HTTP client");
    }

    public synchronized void stop() throws Exception {
        super.stop();
        this.getLogger().info("Stopping the HTTP client");
    }
}

