/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.engine.ClientHelper;
import org.restlet.engine.http.HttpClientAdapter;
import org.restlet.engine.http.HttpClientCall;

public abstract class HttpClientHelper
extends ClientHelper {
    private volatile HttpClientAdapter converter = null;

    public HttpClientHelper(Client client) {
        super(client);
    }

    public abstract HttpClientCall create(Request var1);

    public HttpClientAdapter getConverter() throws Exception {
        if (this.converter == null) {
            String converterClass = this.getHelpedParameters().getFirstValue("converter", "org.restlet.engine.http.HttpClientAdapter");
            this.converter = (HttpClientAdapter)Class.forName(converterClass).getConstructor(Context.class).newInstance(this.getContext());
        }
        return this.converter;
    }

    public void handle(Request request, Response response) {
        try {
            HttpClientCall httpCall = this.getConverter().toSpecific(this, request);
            this.getConverter().commit(httpCall, request, response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Error while handling an HTTP client call", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    public void setConverter(HttpClientAdapter converter) {
        this.converter = converter;
    }
}

