/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.converter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.ObjectRepresentation;
import org.restlet.representation.ReaderRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConverter
extends ConverterHelper {
    private static final Variant VARIANT_FORM = new Variant(MediaType.APPLICATION_WWW_FORM);
    private static final Variant VARIANT_OBJECT = new Variant(MediaType.APPLICATION_JAVA_OBJECT);
    private static final Variant VARIANT_OBJECT_XML = new Variant(MediaType.APPLICATION_JAVA_OBJECT_XML);
    private static final Variant VARIANT_OCTETS = new Variant(MediaType.APPLICATION_OCTET_STREAM);
    private static final Variant VARIANT_TEXT = new Variant(MediaType.TEXT_PLAIN);

    @Override
    public List<Class<?>> getObjectClasses(Variant variant) {
        List<Class<?>> result = null;
        result = this.addObjectClass(result, String.class);
        result = this.addObjectClass(result, InputStream.class);
        result = this.addObjectClass(result, Reader.class);
        result = this.addObjectClass(result, ReadableByteChannel.class);
        if (variant.getMediaType() != null) {
            MediaType mediaType = variant.getMediaType();
            if (MediaType.APPLICATION_JAVA_OBJECT.equals(mediaType) || MediaType.APPLICATION_JAVA_OBJECT_XML.equals(mediaType)) {
                result = this.addObjectClass(result, Object.class);
            } else if (MediaType.APPLICATION_WWW_FORM.equals(mediaType)) {
                result = this.addObjectClass(result, Form.class);
            }
        }
        return result;
    }

    @Override
    public List<Variant> getVariants(Class<?> objectClass) {
        List<Variant> result = null;
        if (String.class.isAssignableFrom(objectClass) || StringRepresentation.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_TEXT);
        } else if (File.class.isAssignableFrom(objectClass) || FileRepresentation.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_OCTETS);
        } else if (InputStream.class.isAssignableFrom(objectClass) || InputRepresentation.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_OCTETS);
        } else if (Reader.class.isAssignableFrom(objectClass) || ReaderRepresentation.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_TEXT);
        } else if (Representation.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_OCTETS);
        } else if (Form.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_FORM);
        }
        if (Serializable.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_OBJECT);
            result = this.addVariant(result, VARIANT_OBJECT_XML);
        }
        return result;
    }

    @Override
    public <T> T toObject(Representation representation, Class<T> targetClass, UniformResource resource) throws IOException {
        Object result = null;
        if (representation != null) {
            if (targetClass != null) {
                if (targetClass.isAssignableFrom(representation.getClass())) {
                    result = representation;
                } else if (String.class.isAssignableFrom(targetClass)) {
                    result = representation.getText();
                } else if (StringRepresentation.class.isAssignableFrom(targetClass)) {
                    result = new StringRepresentation((CharSequence)representation.getText(), representation.getMediaType());
                } else if (EmptyRepresentation.class.isAssignableFrom(targetClass)) {
                    result = null;
                } else if (File.class.isAssignableFrom(targetClass)) {
                    if (representation instanceof FileRepresentation) {
                        result = ((FileRepresentation)representation).getFile();
                    }
                } else if (Form.class.isAssignableFrom(targetClass)) {
                    result = new Form(representation);
                } else if (InputStream.class.isAssignableFrom(targetClass)) {
                    result = representation.getStream();
                } else if (InputRepresentation.class.isAssignableFrom(targetClass)) {
                    result = new InputRepresentation(representation.getStream());
                } else if (Reader.class.isAssignableFrom(targetClass)) {
                    result = representation.getReader();
                } else if (ReaderRepresentation.class.isAssignableFrom(targetClass)) {
                    result = new ReaderRepresentation(representation.getReader());
                } else if (Serializable.class.isAssignableFrom(targetClass)) {
                    try {
                        result = new ObjectRepresentation(representation).getObject();
                    }
                    catch (Exception e) {
                        IOException ioe = new IOException("Unable to create the Object representation");
                        ioe.initCause(e);
                    }
                }
            }
            if (result instanceof Representation) {
                Representation resultRepresentation = (Representation)result;
                resultRepresentation.setCharacterSet(representation.getCharacterSet());
                resultRepresentation.setMediaType(representation.getMediaType());
                resultRepresentation.setEncodings(representation.getEncodings());
                resultRepresentation.setLanguages(representation.getLanguages());
            }
        }
        return (T)result;
    }

    @Override
    public Representation toRepresentation(Object object, Variant targetVariant, UniformResource resource) throws IOException {
        Representation result = null;
        if (object instanceof String) {
            result = new StringRepresentation((CharSequence)((String)object), targetVariant == null ? null : targetVariant.getMediaType());
        } else if (object instanceof File) {
            result = new FileRepresentation((File)object, targetVariant == null ? null : targetVariant.getMediaType());
        } else if (object instanceof Form) {
            result = ((Form)object).getWebRepresentation();
        } else if (object instanceof InputStream) {
            result = new InputRepresentation((InputStream)object, targetVariant == null ? null : targetVariant.getMediaType());
        } else if (object instanceof Reader) {
            result = new ReaderRepresentation((Reader)object, targetVariant == null ? null : targetVariant.getMediaType());
        } else if (object instanceof Representation) {
            result = (Representation)object;
        } else if (object instanceof Serializable) {
            result = new ObjectRepresentation<Serializable>((Serializable)object, targetVariant == null ? null : targetVariant.getMediaType());
        }
        if (result != null && targetVariant != null) {
            result.setCharacterSet(targetVariant.getCharacterSet());
            result.setMediaType(targetVariant.getMediaType());
            result.setEncodings(targetVariant.getEncodings());
            result.setLanguages(targetVariant.getLanguages());
        }
        return result;
    }
}

