/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.converter;

import java.util.List;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterUtils {
    public static ConverterHelper getHelper(Object sourceObject, Variant targetVariant, UniformResource resource) {
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            List<Variant> variants = ch.getVariants(sourceObject.getClass());
            if (variants == null) continue;
            if (targetVariant != null) {
                for (Variant variant : variants) {
                    if (!variant.isCompatible(targetVariant)) continue;
                    return ch;
                }
                continue;
            }
            return ch;
        }
        return null;
    }

    public static <T> ConverterHelper getHelper(Variant sourceVariant, Class<T> targetClass, UniformResource resource) {
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            List<Class<?>> classes = ch.getObjectClasses(sourceVariant);
            if (classes == null) continue;
            if (targetClass != null) {
                for (Class<T> clazz : classes) {
                    if (!clazz.isAssignableFrom(targetClass)) continue;
                    return ch;
                }
                continue;
            }
            return ch;
        }
        return null;
    }

    private ConverterUtils() {
    }
}

