/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.engine.component.HostRoute;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.VirtualHost;

public class ServerRouter
extends Router {
    private volatile Component component;

    public ServerRouter(Component component) {
        super(component == null ? null : component.getContext().createChildContext());
        this.component = component;
        this.setRoutingMode(2);
    }

    private Component getComponent() {
        return this.component;
    }

    public synchronized void start() throws Exception {
        for (VirtualHost host : this.getComponent().getHosts()) {
            this.getRoutes().add(new HostRoute(this, host));
        }
        if (this.getComponent().getDefaultHost() != null) {
            this.getRoutes().add(new HostRoute(this, this.getComponent().getDefaultHost()));
        }
        Restlet noHostMatched = new Restlet(this.getComponent().getContext().createChildContext()){

            public void handle(Request request, Response response) {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "No virtual host could handle the request");
            }
        };
        this.setDefaultRoute(new Route((Router)this, "", noHostMatched));
        super.start();
    }

    public synchronized void stop() throws Exception {
        this.getRoutes().clear();
        super.stop();
    }
}

