/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.http.PreferenceUtils;
import org.restlet.routing.Filter;
import org.restlet.service.MetadataService;
import org.restlet.service.TunnelService;
import org.restlet.util.Series;

public class TunnelFilter
extends Filter {
    public TunnelFilter(Context context) {
        super(context);
    }

    public int beforeHandle(Request request, Response response) {
        if (this.getTunnelService().isUserAgentTunnel()) {
            this.processUserAgent(request);
        }
        if (this.getTunnelService().isExtensionsTunnel()) {
            this.processExtensions(request);
        }
        if (this.getTunnelService().isQueryTunnel()) {
            this.processQuery(request);
        }
        if (this.getTunnelService().isHeadersTunnel()) {
            this.processHeaders(request);
        }
        return 0;
    }

    private Metadata getMetadata(String extension) {
        return this.getMetadataService().getMetadata(extension);
    }

    public MetadataService getMetadataService() {
        return this.getApplication().getMetadataService();
    }

    public TunnelService getTunnelService() {
        return this.getApplication().getTunnelService();
    }

    private boolean processExtensions(Request request) {
        Reference resourceRef;
        TunnelService tunnelService = this.getTunnelService();
        boolean extensionsModified = false;
        Method method = request.getMethod();
        if (tunnelService.isPreferencesTunnel() && (method.equals(Method.GET) || method.equals(Method.HEAD)) && (resourceRef = request.getResourceRef()).hasExtensions()) {
            String extensions;
            boolean languageFound;
            boolean mediaTypeFound;
            boolean characterSetFound;
            boolean encodingFound;
            block9: {
                ClientInfo clientInfo = request.getClientInfo();
                encodingFound = false;
                characterSetFound = false;
                mediaTypeFound = false;
                languageFound = false;
                extensions = resourceRef.getExtensions();
                while (true) {
                    int lastIndexOfPoint = extensions.lastIndexOf(46);
                    String extension = extensions.substring(lastIndexOfPoint + 1);
                    Metadata metadata = this.getMetadata(extension);
                    if (!mediaTypeFound && metadata instanceof MediaType) {
                        this.updateMetadata(clientInfo, metadata);
                        mediaTypeFound = true;
                    } else if (!languageFound && metadata instanceof Language) {
                        this.updateMetadata(clientInfo, metadata);
                        languageFound = true;
                    } else if (!characterSetFound && metadata instanceof CharacterSet) {
                        this.updateMetadata(clientInfo, metadata);
                        characterSetFound = true;
                    } else {
                        if (encodingFound || !(metadata instanceof Encoding)) break block9;
                        this.updateMetadata(clientInfo, metadata);
                        encodingFound = true;
                    }
                    if (lastIndexOfPoint <= 0) break;
                    extensions = extensions.substring(0, lastIndexOfPoint);
                }
                extensions = "";
            }
            if (encodingFound || characterSetFound || mediaTypeFound || languageFound) {
                resourceRef.setExtensions(extensions);
                extensionsModified = true;
            }
        }
        return extensionsModified;
    }

    private void processHeaders(Request request) {
        String newMethodValue;
        Series extraHeaders;
        TunnelService tunnelService = this.getTunnelService();
        if (tunnelService.isMethodTunnel() && (extraHeaders = (Series)request.getAttributes().get("org.restlet.http.headers")) != null && (newMethodValue = extraHeaders.getFirstValue(this.getTunnelService().getMethodHeader(), true)) != null && newMethodValue.trim().length() > 0) {
            request.setMethod(Method.valueOf(newMethodValue));
        }
    }

    private boolean processQuery(Request request) {
        TunnelService tunnelService = this.getTunnelService();
        boolean queryModified = false;
        Reference resourceRef = request.getResourceRef();
        if (resourceRef.hasQuery()) {
            String methodName;
            Method tunnelledMethod;
            Form query = resourceRef.getQueryAsForm();
            Method method = request.getMethod();
            if (tunnelService.isMethodTunnel() && (tunnelledMethod = Method.valueOf(methodName = query.getFirstValue(tunnelService.getMethodParameter()))) != null && (Method.POST.equals(method) || Method.OPTIONS.equals(tunnelledMethod))) {
                request.setMethod(tunnelledMethod);
                query.removeFirst(tunnelService.getMethodParameter());
                queryModified = true;
            }
            if (tunnelService.isPreferencesTunnel()) {
                String charSetParameter = tunnelService.getCharacterSetParameter();
                String encodingParameter = tunnelService.getEncodingParameter();
                String languageParameter = tunnelService.getLanguageParameter();
                String mediaTypeParameter = tunnelService.getMediaTypeParameter();
                String acceptedCharSet = query.getFirstValue(charSetParameter);
                String acceptedEncoding = query.getFirstValue(encodingParameter);
                String acceptedLanguage = query.getFirstValue(languageParameter);
                String acceptedMediaType = query.getFirstValue(mediaTypeParameter);
                ClientInfo clientInfo = request.getClientInfo();
                Metadata metadata = this.getMetadata(acceptedCharSet);
                if (metadata == null && acceptedCharSet != null) {
                    metadata = CharacterSet.valueOf(acceptedCharSet);
                }
                if (metadata instanceof CharacterSet) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(charSetParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedEncoding)) == null && acceptedEncoding != null) {
                    metadata = Encoding.valueOf(acceptedEncoding);
                }
                if (metadata instanceof Encoding) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(encodingParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedLanguage)) == null && acceptedLanguage != null) {
                    metadata = Language.valueOf(acceptedLanguage);
                }
                if (metadata instanceof Language) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(languageParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedMediaType)) == null && acceptedMediaType != null) {
                    metadata = MediaType.valueOf(acceptedMediaType);
                }
                if (metadata instanceof MediaType) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(mediaTypeParameter);
                    queryModified = true;
                }
            }
            if (queryModified) {
                request.getResourceRef().setQuery(query.getQueryString(null));
            }
        }
        return queryModified;
    }

    private void processUserAgent(Request request) {
        URL userAgentPropertiesUrl;
        Map<String, String> agentAttributes = request.getClientInfo().getAgentAttributes();
        if (agentAttributes != null && (userAgentPropertiesUrl = Engine.getClassLoader().getResource("org/restlet/service/accept.properties")) != null) {
            Form headers = (Form)request.getAttributes().get("org.restlet.http.headers");
            String acceptOld = headers != null ? headers.getFirstValue("Accept", true) : null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(userAgentPropertiesUrl.openStream(), CharacterSet.UTF_8.getName()));
                boolean processAcceptHeader = true;
                String line = reader.readLine();
                while (line != null) {
                    String[] keyValue;
                    if (!line.startsWith("#") && (keyValue = line.split(":")).length == 2) {
                        String key = keyValue[0].trim();
                        String value = keyValue[1].trim();
                        if ("acceptNew".equalsIgnoreCase(key)) {
                            if (processAcceptHeader) {
                                ClientInfo clientInfo = new ClientInfo();
                                PreferenceUtils.parseMediaTypes(value, clientInfo);
                                request.getClientInfo().setAcceptedMediaTypes(clientInfo.getAcceptedMediaTypes());
                                break;
                            }
                            processAcceptHeader = true;
                        } else if (processAcceptHeader) {
                            String attribute;
                            processAcceptHeader = "acceptOld".equalsIgnoreCase(key) && value != null && value.length() != 0 ? value.equalsIgnoreCase(acceptOld) : (attribute = agentAttributes.get(key)) != null && attribute.equalsIgnoreCase(value);
                        }
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void updateMetadata(ClientInfo clientInfo, Metadata metadata) {
        if (metadata != null) {
            if (metadata instanceof CharacterSet) {
                clientInfo.getAcceptedCharacterSets().clear();
                clientInfo.getAcceptedCharacterSets().add(new Preference<CharacterSet>((CharacterSet)metadata));
            } else if (metadata instanceof Encoding) {
                clientInfo.getAcceptedEncodings().clear();
                clientInfo.getAcceptedEncodings().add(new Preference<Encoding>((Encoding)metadata));
            } else if (metadata instanceof Language) {
                clientInfo.getAcceptedLanguages().clear();
                clientInfo.getAcceptedLanguages().add(new Preference<Language>((Language)metadata));
            } else if (metadata instanceof MediaType) {
                clientInfo.getAcceptedMediaTypes().clear();
                clientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>((MediaType)metadata));
            }
        }
    }
}

