/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.routing.Filter;
import org.restlet.service.StatusService;

public class StatusFilter
extends Filter {
    private volatile String contactEmail;
    private volatile Reference homeRef;
    private volatile boolean overwrite;
    private volatile StatusService statusService;

    public StatusFilter(Context context, boolean overwrite, String email, Reference homeRef) {
        super(context);
        this.overwrite = overwrite;
        this.contactEmail = email;
        this.homeRef = homeRef;
        this.statusService = null;
    }

    public StatusFilter(Context context, StatusService statusService) {
        this(context, statusService.isOverwrite(), statusService.getContactEmail(), statusService.getHomeRef());
        this.statusService = statusService;
    }

    public void afterHandle(Request request, Response response) {
        if (response.getStatus() == null) {
            response.setStatus(Status.SUCCESS_OK);
        }
        if (response.getStatus().isError() && (response.getEntity() == null || this.isOverwrite())) {
            response.setEntity(this.getRepresentation(response.getStatus(), request, response));
        }
    }

    public int doHandle(Request request, Response response) {
        try {
            super.doHandle(request, response);
        }
        catch (Throwable t) {
            response.setStatus(this.getStatus(t, request, response));
        }
        return 0;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public Representation getDefaultRepresentation(Status status, Request request, Response response) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("   <title>Status page</title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("<h3>");
        if (status.getDescription() != null) {
            sb.append(status.getDescription());
        } else {
            sb.append("No description available for this result status");
        }
        sb.append("</h3>");
        sb.append("<p>You can get technical details <a href=\"");
        sb.append(status.getUri());
        sb.append("\">here</a>.<br>\n");
        if (this.getContactEmail() != null) {
            sb.append("For further assistance, you can contact the <a href=\"mailto:");
            sb.append(this.getContactEmail());
            sb.append("\">administrator</a>.<br>\n");
        }
        if (this.getHomeRef() != null) {
            sb.append("Please continue your visit at our <a href=\"");
            sb.append(this.getHomeRef());
            sb.append("\">home page</a>.\n");
        }
        sb.append("</p>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
    }

    public Reference getHomeRef() {
        return this.homeRef;
    }

    public Representation getRepresentation(Status status, Request request, Response response) {
        Representation result = this.getStatusService().getRepresentation(status, request, response);
        if (result == null) {
            result = this.getDefaultRepresentation(status, request, response);
        }
        return result;
    }

    public Status getStatus(Throwable throwable, Request request, Response response) {
        Status result = this.getStatusService().getStatus(throwable, request, response);
        if (result == null) {
            this.getLogger().log(Level.SEVERE, "Unhandled exception or error intercepted", throwable);
            result = new Status(Status.SERVER_ERROR_INTERNAL, throwable);
        }
        return result;
    }

    public StatusService getStatusService() {
        return this.statusService;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setContactEmail(String email) {
        this.contactEmail = email;
    }

    public void setHomeRef(Reference homeRef) {
        this.homeRef = homeRef;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }
}

