/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import org.restlet.data.Metadata;

public final class Protocol
extends Metadata {
    public static final int UNKNOWN_PORT = -1;
    public static final Protocol AJP = new Protocol("ajp", "AJP", "Apache Jakarta Protocol", 8009);
    public static final Protocol ALL = new Protocol("all", "ALL", "Wildcard for all protocols", -1);
    public static final Protocol CLAP = new Protocol("clap", "CLAP", "Class Loader Access Protocol", -1, true);
    public static final Protocol FILE = new Protocol("file", "FILE", "Local File System Protocol", -1, true);
    public static final Protocol FTP = new Protocol("ftp", "FTP", "File Transfer Protocol", 21);
    public static final Protocol HTTP = new Protocol("http", "HTTP", "HyperText Transport Protocol", 80);
    public static final Protocol HTTPS = new Protocol("https", "HTTPS", "HyperText Transport Protocol (Secure)", 443, true);
    public static final Protocol JAR = new Protocol("jar", "JAR", "Java ARchive", -1, true);
    public static final Protocol JDBC = new Protocol("jdbc", "JDBC", "Java DataBase Connectivity", -1);
    public static final Protocol POP = new Protocol("pop", "POP", "Post Office Protocol", 110);
    public static final Protocol POPS = new Protocol("pops", "POPS", "Post Office Protocol (Secure)", 995, true);
    public static final Protocol RIAP = new Protocol("riap", "RIAP", "Restlet Internal Access Protocol", -1, true);
    public static final Protocol SMTP = new Protocol("smtp", "SMTP", "Simple Mail Transfer Protocol", 25);
    public static final Protocol SMTPS = new Protocol("smtps", "SMTPS", "Simple Mail Transfer Protocol (Secure)", 465, true);
    public static final Protocol WAR = new Protocol("war", "WAR", "Web Archive Access Protocol", -1, true);
    public static final Protocol ZIP = new Protocol("zip", "ZIP", "Zip Archive Access Protocol", -1, true);
    private volatile boolean confidential;
    private volatile int defaultPort;
    private volatile String schemeName;

    public static Protocol valueOf(String name) {
        Protocol result = null;
        if (name != null && !name.equals("")) {
            result = name.equalsIgnoreCase(AJP.getSchemeName()) ? AJP : (name.equalsIgnoreCase(CLAP.getSchemeName()) ? CLAP : (name.equalsIgnoreCase(FILE.getSchemeName()) ? FILE : (name.equalsIgnoreCase(FTP.getSchemeName()) ? FTP : (name.equalsIgnoreCase(HTTP.getSchemeName()) ? HTTP : (name.equalsIgnoreCase(HTTPS.getSchemeName()) ? HTTPS : (name.equalsIgnoreCase(JAR.getSchemeName()) ? JAR : (name.equalsIgnoreCase(JDBC.getSchemeName()) ? JDBC : (name.equalsIgnoreCase(POP.getSchemeName()) ? POP : (name.equalsIgnoreCase(POPS.getSchemeName()) ? POPS : (name.equalsIgnoreCase(RIAP.getSchemeName()) ? RIAP : (name.equalsIgnoreCase(SMTP.getSchemeName()) ? SMTP : (name.equalsIgnoreCase(SMTPS.getSchemeName()) ? SMTPS : (name.equalsIgnoreCase(WAR.getSchemeName()) ? WAR : (name.equalsIgnoreCase(ZIP.getSchemeName()) ? ZIP : new Protocol(name)))))))))))))));
        }
        return result;
    }

    public Protocol(String schemeName) {
        this(schemeName, schemeName.toUpperCase(), schemeName.toUpperCase() + " Protocol", -1);
    }

    public Protocol(String schemeName, String name, String description, int defaultPort) {
        this(schemeName, name, description, defaultPort, false);
    }

    public Protocol(String schemeName, String name, String description, int defaultPort, boolean confidential) {
        super(name, description);
        this.schemeName = schemeName;
        this.defaultPort = defaultPort;
        this.confidential = confidential;
    }

    public boolean equals(Object object) {
        return object instanceof Protocol && this.getName().equalsIgnoreCase(((Protocol)object).getName());
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }

    public boolean isConfidential() {
        return this.confidential;
    }
}

