/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message {
    private volatile Map<String, Object> attributes = null;
    private volatile Representation entity;
    private volatile Form entityForm;
    private volatile String entityText;

    public Message() {
        this(null);
    }

    public Message(Representation entity) {
        this.entity = entity;
        this.entityForm = null;
        this.entityText = null;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, Object>();
        }
        return this.attributes;
    }

    public Representation getEntity() {
        return this.entity;
    }

    public Form getEntityAsForm() {
        if (this.entityForm == null) {
            this.entityForm = new Form(this.getEntity());
        }
        return this.entityForm;
    }

    public String getEntityAsText() {
        if (this.entityText == null) {
            try {
                this.entityText = this.getEntity().getText();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.FINE, "Unable to get the entity text.", e);
            }
        }
        return this.entityText;
    }

    public abstract boolean isConfidential();

    public boolean isEntityAvailable() {
        return this.getEntity() != null && this.getEntity().getSize() != 0L && this.getEntity().isAvailable();
    }

    public void release() {
        if (this.getEntity() != null) {
            this.getEntity().release();
        }
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setEntity(Representation entity) {
        this.entity = entity;
    }

    public void setEntity(String value, MediaType mediaType) {
        this.setEntity(new StringRepresentation((CharSequence)value, mediaType));
    }
}

