/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Arrays;

public class Digest {
    public static final String ALGORITHM_MD2 = "MD2";
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA_1 = "SHA-1";
    public static final String ALGORITHM_SHA_256 = "SHA-256";
    public static final String ALGORITHM_SHA_384 = "SHA-384";
    public static final String ALGORITHM_SHA_512 = "SHA-512";
    private final String algorithm;
    private final byte[] value;

    public Digest(byte[] value) {
        this(ALGORITHM_MD5, value);
    }

    public Digest(String algorithm, byte[] value) {
        this.algorithm = algorithm;
        this.value = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.value[i] = value[i];
        }
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof Digest;
        if (result) {
            Digest d = (Digest)obj;
            result = this.getAlgorithm().equals(d.getAlgorithm());
            result = result && Arrays.equals(this.getValue(), d.getValue());
        }
        return result;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getValue() {
        byte[] result = new byte[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            result[i] = this.value[i];
        }
        return result;
    }
}

