/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.nio.charset.Charset;
import org.restlet.data.Metadata;

public final class CharacterSet
extends Metadata {
    public static final CharacterSet ALL = new CharacterSet("*", "All character sets");
    public static final CharacterSet DEFAULT = new CharacterSet(Charset.defaultCharset());
    public static final CharacterSet ISO_8859_1 = new CharacterSet("ISO-8859-1", "ISO/IEC 8859-1 or Latin 1 character set");
    public static final CharacterSet US_ASCII = new CharacterSet("US-ASCII", "US ASCII character set");
    public static final CharacterSet UTF_16 = new CharacterSet("UTF-16", "UTF 16 character set");
    public static final CharacterSet UTF_8 = new CharacterSet("UTF-8", "UTF 8 character set");

    public static CharacterSet valueOf(String name) {
        CharacterSet result = null;
        if (name != null && !name.equals("")) {
            result = name.equalsIgnoreCase(ALL.getName()) ? ALL : (name.equalsIgnoreCase(ISO_8859_1.getName()) ? ISO_8859_1 : (name.equalsIgnoreCase(US_ASCII.getName()) ? US_ASCII : (name.equalsIgnoreCase(UTF_8.getName()) ? UTF_8 : (name.equalsIgnoreCase(UTF_16.getName()) ? UTF_16 : new CharacterSet(name)))));
        }
        return result;
    }

    public CharacterSet(Charset charset) {
        this(charset.name(), charset.displayName());
    }

    public CharacterSet(String name) {
        this(name == null ? null : name.toUpperCase(), "Character set or range of character sets");
    }

    public CharacterSet(String name, String description) {
        super(name == null ? null : name.toUpperCase(), description);
    }

    public boolean equals(Object object) {
        return object instanceof CharacterSet && this.getName().equalsIgnoreCase(((CharacterSet)object).getName());
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }

    public Charset toCharset() {
        return Charset.forName(this.getName());
    }
}

