/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.component.ChildContext;

public class Restlet
extends Uniform {
    private static final String UNABLE_TO_START = "Unable to start the Restlet";
    private volatile Context context;
    private volatile boolean started;

    public Restlet() {
        this(null);
    }

    public Restlet(Context context) {
        this.context = context;
        this.started = false;
        if (Engine.getInstance() == null) {
            Context.getCurrentLogger().severe("Unable to fully initialize the Restlet. No Restlet engine available.");
            throw new RuntimeException("Unable to fully initialize the Restlet. No Restlet engine available.");
        }
        ChildContext.fireContextChanged(this, context);
    }

    public Application getApplication() {
        return Application.getCurrent();
    }

    public Context getContext() {
        return this.context;
    }

    public Logger getLogger() {
        Logger result = null;
        Context context = this.getContext();
        if (context == null) {
            context = Context.getCurrent();
        }
        if (context != null) {
            result = context.getLogger();
        }
        if (result == null) {
            result = Logger.getLogger(this.getClass().getCanonicalName());
        }
        if (result == null) {
            result = Logger.getLogger("org.restlet.Restlet");
        }
        return result;
    }

    public void handle(Request request, Response response) {
        Response.setCurrent(response);
        if (this.getContext() != null) {
            Context.setCurrent(this.getContext());
        }
        if (this.isStopped()) {
            try {
                this.start();
            }
            catch (Exception e) {
                this.getContext().getLogger().log(Level.WARNING, UNABLE_TO_START, e);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
            if (!this.isStarted()) {
                this.getContext().getLogger().log(Level.WARNING, UNABLE_TO_START);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void setContext(Context context) {
        this.context = context;
        ChildContext.fireContextChanged(this, context);
    }

    public synchronized void start() throws Exception {
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }
}

