/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.data.Response;
import org.restlet.resource.OutputRepresentation;
import org.restlet.resource.Representation;

public class TransformRepresentation
extends OutputRepresentation {
    private Representation sourceRepresentation;
    private Transformer transformer;
    private Representation transformSheet;
    private URIResolver uriResolver;

    public TransformRepresentation(Context context, Representation source, Representation transformSheet) {
        super(null);
        this.sourceRepresentation = source;
        this.transformSheet = transformSheet;
        this.uriResolver = context == null ? null : new ContextResolver(context);
    }

    public Representation getSourceRepresentation() {
        return this.sourceRepresentation;
    }

    public Transformer getTransformer() throws IOException {
        if (this.transformer == null) {
            try {
                StreamSource transformSource = new StreamSource(this.getTransformSheet().getStream());
                if (this.getTransformSheet().getIdentifier() != null) {
                    transformSource.setSystemId(this.getTransformSheet().getIdentifier().getTargetRef().toString());
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                if (this.getUriResolver() != null) {
                    transformerFactory.setURIResolver(this.getUriResolver());
                }
                this.transformer = transformerFactory.newTransformer(transformSource);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Transformer configuration exception. " + tce.getMessage());
            }
            catch (TransformerFactoryConfigurationError tfce) {
                throw new IOException("Transformer factory configuration exception. " + tfce.getMessage());
            }
        }
        return this.transformer;
    }

    public Representation getTransformSheet() {
        return this.transformSheet;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    @Deprecated
    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void release() {
        if (this.sourceRepresentation != null) {
            this.sourceRepresentation.release();
            this.sourceRepresentation = null;
        }
        if (this.transformer != null) {
            this.transformer = null;
        }
        if (this.transformSheet != null) {
            this.transformSheet.release();
            this.transformSheet = null;
        }
        if (this.uriResolver != null) {
            this.uriResolver = null;
        }
        super.release();
    }

    public void setSourceRepresentation(Representation source) {
        this.sourceRepresentation = source;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public void setTransformSheet(Representation transformSheet) {
        this.transformSheet = transformSheet;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            StreamSource sourceDocument = new StreamSource(this.getSourceRepresentation().getStream());
            if (this.getSourceRepresentation().getIdentifier() != null) {
                sourceDocument.setSystemId(this.getSourceRepresentation().getIdentifier().getTargetRef().toString());
            }
            StreamResult resultDocument = new StreamResult(outputStream);
            this.getTransformer().transform(sourceDocument, resultDocument);
        }
        catch (TransformerException te) {
            throw new IOException("Transformer exception. " + te.getMessage());
        }
    }

    private static final class ContextResolver
    implements URIResolver {
        private Context context;

        public ContextResolver(Context context) {
            this.context = context;
        }

        public Source resolve(String href, String base) throws TransformerException {
            StreamSource result = null;
            if (this.context != null) {
                Reference targetRef = null;
                if (base != null && !base.equals("")) {
                    Reference baseRef = new Reference(base);
                    targetRef = new Reference(baseRef, href);
                } else {
                    targetRef = new Reference(href);
                }
                String targetUri = targetRef.getTargetRef().toString();
                Response response = this.context.getClientDispatcher().get(targetUri);
                if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                    try {
                        result = new StreamSource(response.getEntity().getStream());
                        result.setSystemId(targetUri);
                    }
                    catch (IOException e) {
                        this.context.getLogger().log(Level.WARNING, "I/O error while getting the response stream", e);
                    }
                }
            }
            return result;
        }
    }
}

