/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.restlet.data.MediaType;
import org.restlet.resource.Representation;
import org.restlet.resource.XmlRepresentation;
import org.restlet.util.XmlWriter;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class SaxRepresentation
extends XmlRepresentation {
    private Document xmlDocument;
    private Representation xmlRepresentation;

    public SaxRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    public SaxRepresentation(MediaType mediaType, Document xmlDocument) {
        super(mediaType);
        this.xmlDocument = xmlDocument;
    }

    public SaxRepresentation(Representation xmlRepresentation) {
        super(xmlRepresentation.getMediaType());
        this.xmlRepresentation = xmlRepresentation;
    }

    public void parse(ContentHandler contentHandler) throws IOException {
        if (contentHandler != null) {
            try {
                Source source = null;
                source = this.xmlDocument != null ? new DOMSource(this.xmlDocument) : new StreamSource(this.xmlRepresentation.getStream());
                if (this.xmlRepresentation.getIdentifier() != null) {
                    source.setSystemId(this.xmlRepresentation.getIdentifier().getTargetRef().toString());
                }
                SAXResult result = new SAXResult(contentHandler);
                TransformerFactory.newInstance().newTransformer().transform(source, result);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Couldn't parse the source representation: " + tce.getMessage());
            }
            catch (TransformerException te) {
                te.printStackTrace();
                throw new IOException("Couldn't parse the source representation: " + te.getMessage());
            }
            catch (TransformerFactoryConfigurationError tfce) {
                throw new IOException("Couldn't parse the source representation: " + tfce.getMessage());
            }
        } else {
            throw new IOException("Couldn't parse the source representation: no content restlet defined.");
        }
    }

    public void release() {
        if (this.xmlDocument != null) {
            this.xmlDocument = null;
        }
        if (this.xmlRepresentation != null) {
            this.xmlRepresentation.release();
            this.xmlRepresentation = null;
        }
        super.release();
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new XmlWriter(outputStream, "UTF-8"));
    }

    public void write(XmlWriter writer) throws IOException {
    }

    private DocumentBuilder getDocumentBuilder() throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(this.isNamespaceAware());
            dbf.setValidating(false);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Couldn't create the empty document: " + pce.getMessage());
        }
    }

    public Source getSource() throws IOException {
        return new SAXSource(new InputSource(this.getStream()));
    }

    public Object evaluate(String expression, QName returnType) throws Exception {
        Object result = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(this);
        if (this.xmlDocument == null) {
            this.xmlDocument = this.getDocumentBuilder().parse(this.xmlRepresentation.getStream());
        }
        if (this.xmlDocument == null) {
            throw new Exception("Unable to obtain a DOM document for the SAX representation. XPath evaluation cancelled.");
        }
        result = xpath.evaluate(expression, this.xmlDocument, returnType);
        return result;
    }
}

