/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.util.ArrayList;
import java.util.List;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Handler;
import org.restlet.data.Dimension;
import org.restlet.data.Language;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource
extends Handler {
    private boolean available;
    private boolean modifiable;
    private boolean negotiateContent;
    private boolean readable;
    private List<Variant> variants;

    public Resource() {
    }

    public Resource(Context context, Request request, Response response) {
        super(context, request, response);
        this.available = true;
        this.modifiable = false;
        this.negotiateContent = true;
        this.readable = true;
        this.variants = null;
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    @Override
    public boolean allowDelete() {
        return this.isModifiable();
    }

    @Override
    public boolean allowGet() {
        return this.isReadable();
    }

    @Override
    public boolean allowPost() {
        return this.isModifiable();
    }

    @Override
    public boolean allowPut() {
        return this.isModifiable();
    }

    @Deprecated
    public void delete() {
        try {
            this.removeRepresentations();
        }
        catch (ResourceException re) {
            this.getResponse().setStatus(re.getStatus());
        }
    }

    @Deprecated
    public Representation getPreferredRepresentation() {
        Representation result = null;
        try {
            result = this.represent();
        }
        catch (ResourceException re) {
            this.getResponse().setStatus(re.getStatus());
        }
        return result;
    }

    public Variant getPreferredVariant() {
        Variant result = null;
        List<Variant> variants = this.getVariants();
        if (variants != null && !variants.isEmpty()) {
            Language language = null;
            Object app = this.getContext().getAttributes().get("org.restlet.application");
            if (app instanceof Application) {
                language = ((Application)app).getMetadataService().getDefaultLanguage();
            }
            result = this.getRequest().getClientInfo().getPreferredVariant(variants, language);
        }
        return result;
    }

    @Deprecated
    public Representation getRepresentation(Variant variant) {
        Representation result = null;
        try {
            result = this.represent(variant);
        }
        catch (ResourceException re) {
            this.getResponse().setStatus(re.getStatus());
        }
        return result;
    }

    public List<Variant> getVariants() {
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        return this.variants;
    }

    @Override
    public void handleDelete() {
        boolean canDelete = true;
        if (this.getRequest().getConditions().hasSome()) {
            Status status;
            Variant preferredVariant = null;
            if (this.isNegotiateContent()) {
                preferredVariant = this.getPreferredVariant();
            } else {
                List<Variant> variants = this.getVariants();
                if (variants.size() == 1) {
                    preferredVariant = variants.get(0);
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_PRECONDITION_FAILED);
                    canDelete = false;
                }
            }
            if (canDelete && (status = this.getRequest().getConditions().getStatus(this.getRequest().getMethod(), this.getRepresentation(preferredVariant))) != null) {
                this.getResponse().setStatus(status);
                canDelete = false;
            }
        }
        if (canDelete) {
            this.delete();
        }
    }

    @Override
    public void handleGet() {
        if (!this.isAvailable()) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else {
            Status status;
            Representation selectedRepresentation = null;
            List<Variant> variants = this.getVariants();
            if (variants == null || variants.isEmpty()) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                this.getLogger().warning("A resource should normally have at least one variant added by calling getVariants().add() in the constructor");
            } else if (this.isNegotiateContent()) {
                Variant preferredVariant = this.getPreferredVariant();
                if (preferredVariant == null) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
                    ReferenceList refs = new ReferenceList(variants.size());
                    for (Variant variant : variants) {
                        if (variant.getIdentifier() == null) continue;
                        refs.add(variant.getIdentifier());
                    }
                    this.getResponse().setEntity(refs.getTextRepresentation());
                } else {
                    this.getResponse().getDimensions().clear();
                    this.getResponse().getDimensions().add(Dimension.CHARACTER_SET);
                    this.getResponse().getDimensions().add(Dimension.ENCODING);
                    this.getResponse().getDimensions().add(Dimension.LANGUAGE);
                    this.getResponse().getDimensions().add(Dimension.MEDIA_TYPE);
                    this.getResponse().setEntity(this.getRepresentation(preferredVariant));
                }
                selectedRepresentation = this.getResponse().getEntity();
            } else if (variants.size() == 1) {
                this.getResponse().setEntity(this.getRepresentation(variants.get(0)));
                selectedRepresentation = this.getResponse().getEntity();
            } else {
                ReferenceList variantRefs = new ReferenceList();
                for (Variant variant : variants) {
                    if (variant.getIdentifier() != null) {
                        variantRefs.add(variant.getIdentifier());
                        continue;
                    }
                    this.getLogger().warning("A resource with multiple variants should provide an identifier for each variant when content negotiation is turned off");
                }
                if (variantRefs.size() > 0) {
                    this.getResponse().setStatus(Status.REDIRECTION_MULTIPLE_CHOICES);
                    this.getResponse().setEntity(variantRefs.getTextRepresentation());
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                }
            }
            if (selectedRepresentation == null) {
                if (this.getResponse().getStatus() == null || this.getResponse().getStatus().isSuccess()) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                }
            } else if (this.getRequest().getConditions().hasSome() && (status = this.getRequest().getConditions().getStatus(this.getRequest().getMethod(), selectedRepresentation)) != null) {
                this.getResponse().setStatus(status);
                this.getResponse().setEntity(null);
            }
        }
    }

    @Override
    public void handlePost() {
        if (!this.getRequest().isEntityAvailable()) {
            this.getLogger().fine("POST request received without any entity. Continuing processing.");
        }
        this.post(this.getRequest().getEntity());
    }

    @Override
    public void handlePut() {
        Series headers;
        Object oHeaders;
        boolean canPut = true;
        if (this.getRequest().getConditions().hasSome()) {
            Status status;
            Variant preferredVariant = null;
            if (this.isNegotiateContent()) {
                preferredVariant = this.getPreferredVariant();
            } else {
                List<Variant> variants = this.getVariants();
                if (variants.size() == 1) {
                    preferredVariant = variants.get(0);
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_PRECONDITION_FAILED);
                    canPut = false;
                }
            }
            if (canPut && (status = this.getRequest().getConditions().getStatus(this.getRequest().getMethod(), this.getRepresentation(preferredVariant))) != null) {
                this.getResponse().setStatus(status);
                canPut = false;
            }
        }
        if (canPut && (oHeaders = this.getRequest().getAttributes().get("org.restlet.http.headers")) != null && (headers = (Series)oHeaders).getFirst("Content-Range", true) != null) {
            this.getResponse().setStatus(new Status(Status.SERVER_ERROR_NOT_IMPLEMENTED, "The Content-Range header is not understood"));
            canPut = false;
        }
        if (canPut) {
            if (this.getRequest().isEntityAvailable()) {
                this.put(this.getRequest().getEntity());
                this.updateAllowedMethods();
            } else {
                this.getResponse().setStatus(new Status(Status.CLIENT_ERROR_BAD_REQUEST, "Missing request entity"));
            }
        }
    }

    @Override
    public void init(Context context, Request request, Response response) {
        super.init(context, request, response);
        this.modifiable = false;
        this.negotiateContent = true;
        this.readable = true;
        this.variants = null;
        this.available = true;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isNegotiateContent() {
        return this.negotiateContent;
    }

    public boolean isReadable() {
        return this.readable;
    }

    @Deprecated
    public void post(Representation entity) {
        try {
            this.acceptRepresentation(entity);
        }
        catch (ResourceException re) {
            this.getResponse().setStatus(re.getStatus());
        }
    }

    @Deprecated
    public void put(Representation entity) {
        try {
            this.storeRepresentation(entity);
        }
        catch (ResourceException re) {
            this.getResponse().setStatus(re.getStatus());
        }
    }

    public void removeRepresentations() throws ResourceException {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    public Representation represent() throws ResourceException {
        return this.represent(this.getPreferredVariant());
    }

    public Representation represent(Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof Representation) {
            result = (Representation)variant;
        }
        return result;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public void setNegotiateContent(boolean negotiateContent) {
        this.negotiateContent = negotiateContent;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public void setVariants(List<Variant> variants) {
        this.variants = variants;
    }

    public void storeRepresentation(Representation entity) throws ResourceException {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }
}

