/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import org.restlet.data.MediaType;
import org.restlet.data.Tag;
import org.restlet.resource.Variant;

public abstract class Representation
extends Variant {
    public static final long UNKNOWN_SIZE = -1L;
    private boolean available = true;
    private boolean downloadable;
    private String downloadName;
    private boolean isTransient = false;

    public static Representation createEmpty() {
        return new EmptyRepresentation();
    }

    public Representation() {
        this(null);
    }

    public Representation(MediaType mediaType) {
        super(mediaType);
    }

    public abstract ReadableByteChannel getChannel() throws IOException;

    public String getDownloadName() {
        return this.downloadName;
    }

    public Date getExpirationDate() {
        return super.getExpirationDate();
    }

    public Date getModificationDate() {
        return super.getModificationDate();
    }

    public abstract Reader getReader() throws IOException;

    public long getSize() {
        return super.getSize();
    }

    public abstract InputStream getStream() throws IOException;

    public Tag getTag() {
        return super.getTag();
    }

    public String getText() throws IOException {
        String result = null;
        if (this.isAvailable()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(baos);
            result = this.getCharacterSet() != null ? baos.toString(this.getCharacterSet().getName()) : baos.toString();
        }
        return result;
    }

    public boolean isAvailable() {
        return this.getSize() != 0L && this.available;
    }

    public boolean isDownloadable() {
        return this.downloadable;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void release() {
        this.available = false;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setDownloadable(boolean downloadable) {
        this.downloadable = downloadable;
    }

    public void setDownloadName(String fileName) {
        this.downloadName = fileName;
    }

    public void setExpirationDate(Date expirationDate) {
        super.setExpirationDate(expirationDate);
    }

    public void setModificationDate(Date modificationDate) {
        super.setModificationDate(modificationDate);
    }

    public void setSize(long expectedSize) {
        super.setSize(expectedSize);
    }

    public void setTag(Tag tag) {
        super.setTag(tag);
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public abstract void write(OutputStream var1) throws IOException;

    public abstract void write(WritableByteChannel var1) throws IOException;

    public abstract void write(Writer var1) throws IOException;

    private static class EmptyRepresentation
    extends Representation {
        public EmptyRepresentation() {
            this.setAvailable(false);
            this.setTransient(true);
            this.setSize(0L);
        }

        public ReadableByteChannel getChannel() throws IOException {
            return null;
        }

        public Reader getReader() throws IOException {
            return null;
        }

        public InputStream getStream() throws IOException {
            return null;
        }

        public void write(OutputStream outputStream) throws IOException {
        }

        public void write(WritableByteChannel writableChannel) throws IOException {
        }

        public void write(Writer writer) throws IOException {
        }
    }
}

