/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.MediaType;
import org.restlet.resource.StreamRepresentation;
import org.restlet.util.ByteUtils;

public class InputRepresentation
extends StreamRepresentation {
    private static Logger logger = Logger.getLogger(InputRepresentation.class.getCanonicalName());
    private volatile InputStream stream;

    public InputRepresentation(InputStream inputStream, MediaType mediaType) {
        this(inputStream, mediaType, -1L);
    }

    public InputRepresentation(InputStream inputStream, MediaType mediaType, long expectedSize) {
        super(mediaType);
        this.setSize(expectedSize);
        this.setTransient(true);
        this.setStream(inputStream);
    }

    public InputStream getStream() throws IOException {
        InputStream result = this.stream;
        this.setStream(null);
        return result;
    }

    public String getText() throws IOException {
        return ByteUtils.toString(this.getStream(), this.getCharacterSet());
    }

    public void release() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error while releasing the representation.", e);
            }
            this.stream = null;
        }
        super.release();
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
        this.setAvailable(stream != null);
    }

    public void write(OutputStream outputStream) throws IOException {
        ByteUtils.write(this.getStream(), outputStream);
    }
}

