/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.IOException;
import org.restlet.data.CharacterSet;
import org.restlet.data.Reference;
import org.restlet.util.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter
implements Comparable<Parameter> {
    private volatile String name;
    private volatile String value;

    public Parameter() {
        this(null, null);
    }

    public Parameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public int compareTo(Parameter o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof Parameter) {
            Parameter that = (Parameter)obj;
            if (this.name != null) {
                result = this.name.equals(that.name);
            } else {
                boolean bl2 = result = that.name == null;
            }
            if (result) {
                result = this.value != null ? this.value.equals(that.value) : that.value == null;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Engine.hashCode(this.getName(), this.getValue());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.getName() + ": " + this.getValue();
    }

    public String encode(CharacterSet characterSet) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.encode(sb, characterSet);
        return sb.toString();
    }

    public void encode(Appendable buffer, CharacterSet characterSet) throws IOException {
        if (this.getName() != null) {
            buffer.append(Reference.encode(this.getName(), characterSet));
            if (this.getValue() != null) {
                buffer.append('=');
                buffer.append(Reference.encode(this.getValue(), characterSet));
            }
        }
    }
}

