/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.HashMap;
import java.util.Map;
import org.restlet.data.Form;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.util.Engine;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaType
extends Metadata {
    private static Map<String, MediaType> types = null;
    public static final MediaType ALL = MediaType.register("*/*", "All media");
    public static final MediaType APPLICATION_ALL = MediaType.register("application/*", "All application documents");
    public static final MediaType APPLICATION_ATOM_SERVICE_XML = MediaType.register("application/atomsvc+xml", "Atom service documents");
    public static final MediaType APPLICATION_ATOM_XML = MediaType.register("application/atom+xml", "Atom syndication documents");
    public static final MediaType APPLICATION_CAB = MediaType.register("application/vnd.ms-cab-compressed", "Microsoft Cabinet archive");
    public static final MediaType APPLICATION_EXCEL = MediaType.register("application/vnd.ms-excel", "Microsoft Excel document");
    public static final MediaType APPLICATION_FLASH = MediaType.register("application/x-shockwave-flash", "Shockwave Flash object");
    public static final MediaType APPLICATION_GNU_TAR = MediaType.register("application/x-gtar", "GNU Tar archive");
    public static final MediaType APPLICATION_GNU_ZIP = MediaType.register("application/x-gzip", "GNU Zip archive");
    public static final MediaType APPLICATION_HTTP_COOKIES = MediaType.register("application/x-http-cookies", "HTTP cookies");
    public static final MediaType APPLICATION_JAVA_ARCHIVE = MediaType.register("application/java-archive", "Java archive");
    public static final MediaType APPLICATION_JAVA_OBJECT = MediaType.register("application/x-java-serialized-object", "Java serialized object");
    public static final MediaType APPLICATION_JAVASCRIPT = MediaType.register("application/x-javascript", "Javascript document");
    public static final MediaType APPLICATION_JSON = MediaType.register("application/json", "JavaScript Object Notation document");
    public static final MediaType APPLICATION_OCTET_STREAM = MediaType.register("application/octet-stream", "Raw octet stream");
    public static final MediaType APPLICATION_PDF = MediaType.register("application/pdf", "Adobe PDF document");
    public static final MediaType APPLICATION_POSTSCRIPT = MediaType.register("application/postscript", "Postscript document");
    public static final MediaType APPLICATION_POWERPOINT = MediaType.register("application/vnd.ms-powerpoint", "Microsoft Powerpoint document");
    public static final MediaType APPLICATION_PROJECT = MediaType.register("application/vnd.ms-project", "Microsoft Project document");
    public static final MediaType APPLICATION_RDF_XML = MediaType.register("application/rdf+xml", "XML serialized Resource Description Framework document");
    public static final MediaType APPLICATION_RELAXNG_COMPACT = MediaType.register("application/relax-ng-compact-syntax", "Relax NG Schema document, Compact syntax");
    public static final MediaType APPLICATION_RELAXNG_XML = MediaType.register("application/x-relax-ng+xml", "Relax NG Schema document, XML syntax");
    public static final MediaType APPLICATION_RSS_XML = MediaType.register("application/rss+xml", "Really Simple Syndication document");
    public static final MediaType APPLICATION_RTF = MediaType.register("application/rtf", "Rich Text Format document");
    public static final MediaType APPLICATION_STUFFIT = MediaType.register("application/x-stuffit", "Stuffit archive");
    public static final MediaType APPLICATION_TAR = MediaType.register("application/x-tar", "Tar archive");
    public static final MediaType APPLICATION_W3C_SCHEMA_XML = MediaType.register("application/x-xsd+xml", "W3C XML Schema document");
    public static final MediaType APPLICATION_WADL_XML = MediaType.register("application/vnd.sun.wadl+xml", "Web Application Description Language document");
    public static final MediaType APPLICATION_WORD = MediaType.register("application/msword", "Microsoft Word document");
    public static final MediaType APPLICATION_WWW_FORM = MediaType.register("application/x-www-form-urlencoded", "Web form (URL encoded)");
    public static final MediaType APPLICATION_XHTML_XML = MediaType.register("application/xhtml+xml", "XHTML document");
    public static final MediaType APPLICATION_XML = MediaType.register("application/xml", "XML document");
    public static final MediaType APPLICATION_ZIP = MediaType.register("application/zip", "Zip archive");
    public static final MediaType AUDIO_ALL = MediaType.register("audio/*", "All audios");
    public static final MediaType AUDIO_MPEG = MediaType.register("audio/mpeg", "MPEG audio (MP3)");
    public static final MediaType AUDIO_REAL = MediaType.register("audio/x-pn-realaudio", "Real audio");
    public static final MediaType AUDIO_WAV = MediaType.register("audio/x-wav", "Waveform audio");
    public static final MediaType IMAGE_ALL = MediaType.register("image/*", "All images");
    public static final MediaType IMAGE_BMP = MediaType.register("image/bmp", "Windows bitmap");
    public static final MediaType IMAGE_GIF = MediaType.register("image/gif", "GIF image");
    public static final MediaType IMAGE_ICON = MediaType.register("image/x-icon", "Windows icon (Favicon)");
    public static final MediaType IMAGE_JPEG = MediaType.register("image/jpeg", "JPEG image");
    public static final MediaType IMAGE_PNG = MediaType.register("image/png", "PNG image");
    public static final MediaType IMAGE_SVG = MediaType.register("image/svg+xml", "Scalable Vector Graphics");
    public static final MediaType MESSAGE_ALL = MediaType.register("message/*", "All messages");
    public static final MediaType MODEL_ALL = MediaType.register("model/*", "All models");
    public static final MediaType MULTIPART_ALL = MediaType.register("multipart/*", "All multipart data");
    public static final MediaType MULTIPART_FORM_DATA = MediaType.register("multipart/form-data", "Multipart form data");
    public static final MediaType TEXT_ALL = MediaType.register("text/*", "All texts");
    public static final MediaType TEXT_CALENDAR = MediaType.register("text/calendar", "iCalendar event");
    public static final MediaType TEXT_CSS = MediaType.register("text/css", "CSS stylesheet");
    public static final MediaType TEXT_HTML = MediaType.register("text/html", "HTML document");
    public static final MediaType TEXT_JAVASCRIPT = MediaType.register("text/javascript", "Javascript document");
    public static final MediaType TEXT_PLAIN = MediaType.register("text/plain", "Plain text");
    public static final MediaType TEXT_RDF_N3 = MediaType.register("text/rdf+n3", "N3 serialized Resource Description Framework document");
    public static final MediaType TEXT_URI_LIST = MediaType.register("text/uri-list", "List of URIs");
    public static final MediaType TEXT_VCARD = MediaType.register("text/x-vcard", "vCard");
    public static final MediaType TEXT_XML = MediaType.register("text/xml", "XML text");
    public static final MediaType VIDEO_ALL = MediaType.register("video/*", "All videos");
    public static final MediaType VIDEO_AVI = MediaType.register("video/x-msvideo", "AVI video");
    public static final MediaType VIDEO_MPEG = MediaType.register("video/mpeg", "MPEG video");
    public static final MediaType VIDEO_QUICKTIME = MediaType.register("video/quicktime", "Quicktime video");
    public static final MediaType VIDEO_WMV = MediaType.register("video/x-ms-wmv", "Windows movie");
    private Series<Parameter> parameters;

    public static MediaType getMostSpecific(MediaType ... mediaTypes) throws IllegalArgumentException {
        if (mediaTypes == null || mediaTypes.length == 0) {
            throw new IllegalArgumentException("You must give at least one MediaType");
        }
        if (mediaTypes.length == 1) {
            return mediaTypes[0];
        }
        MediaType mostSpecific = mediaTypes[mediaTypes.length - 1];
        for (int i = mediaTypes.length - 2; i >= 0; --i) {
            MediaType mediaType = mediaTypes[i];
            if (mediaType.getMainType().equals("*")) continue;
            if (mostSpecific.getMainType().equals("*")) {
                mostSpecific = mediaType;
                continue;
            }
            if (!mostSpecific.getSubType().contains("*")) continue;
            mostSpecific = mediaType;
        }
        return mostSpecific;
    }

    public static synchronized MediaType register(String name, String description) {
        if (!MediaType.getTypes().containsKey(name)) {
            MediaType type = new MediaType(name, description);
            MediaType.getTypes().put(name, type);
        }
        return MediaType.getTypes().get(name);
    }

    public static MediaType valueOf(String name) {
        MediaType result = null;
        if (name != null && (result = MediaType.getTypes().get(name)) == null) {
            result = new MediaType(name);
        }
        return result;
    }

    public MediaType(String name) {
        this(name, null, "Media type or range of media types");
    }

    public MediaType(String name, Series<Parameter> parameters) {
        this(name, parameters, "Media type or range of media types");
    }

    public MediaType(String name, Series<Parameter> parameters, String description) {
        super(name == null ? null : name, description);
        this.parameters = parameters;
    }

    public MediaType(String name, String description) {
        this(name, null, description);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Object obj, boolean ignoreParameters) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && super.equals(obj) && obj instanceof MediaType) {
            MediaType that = (MediaType)obj;
            result = ignoreParameters || this.getParameters().equals(that.getParameters());
        }
        return result;
    }

    public String getMainType() {
        String result = null;
        if (this.getName() != null) {
            int index = this.getName().indexOf(47);
            if (index == -1) {
                index = this.getName().indexOf(59);
            }
            result = index == -1 ? this.getName() : this.getName().substring(0, index);
        }
        return result;
    }

    public Series<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new Form();
        }
        return this.parameters;
    }

    public String getSubType() {
        String result = null;
        if (this.getName() != null) {
            int separator;
            int slash = this.getName().indexOf(47);
            result = slash == -1 ? "*" : ((separator = this.getName().indexOf(59)) == -1 ? this.getName().substring(slash + 1) : this.getName().substring(slash + 1, separator));
        }
        return result;
    }

    @Override
    public int hashCode() {
        return Engine.hashCode(super.hashCode(), this.getParameters());
    }

    public boolean includes(MediaType included) {
        boolean result;
        boolean bl = result = this.equals(ALL) || included == null || this.equals(included);
        if (!result) {
            result = this.getMainType().equals(included.getMainType()) && (this.getSubType().equals(included.getSubType()) || this.getSubType().equals("*"));
        }
        return result;
    }

    public boolean isCompatible(MediaType otherMediaType) {
        return this.includes(otherMediaType) || otherMediaType.includes(this);
    }

    public boolean isConcrete() {
        return !this.getName().contains("*");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
            for (Parameter param : this.getParameters()) {
                sb.append("; ").append(param.getName()).append('=').append(param.getValue());
            }
        }
        return sb.toString();
    }

    private static Map<String, MediaType> getTypes() {
        if (types == null) {
            types = new HashMap<String, MediaType>();
        }
        return types;
    }
}

