/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.File;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;

public final class LocalReference
extends Reference {
    public static final int CLAP_CLASS = 1;
    public static final int CLAP_SYSTEM = 2;
    public static final int CLAP_THREAD = 3;
    public static final int RIAP_COMPONENT = 4;
    public static final int RIAP_APPLICATION = 5;

    public static LocalReference createClapReference(int authorityType, String path) {
        return new LocalReference("clap://" + LocalReference.getAuthorityName(authorityType) + path);
    }

    public static LocalReference createFileReference(File file) {
        return LocalReference.createFileReference(file.getAbsolutePath());
    }

    public static LocalReference createFileReference(String filePath) {
        return LocalReference.createFileReference("", filePath);
    }

    public static LocalReference createFileReference(String hostName, String filePath) {
        return new LocalReference("file://" + hostName + "/" + LocalReference.normalizePath(filePath));
    }

    public static LocalReference createJarReference(Reference jarFile, String entryPath) {
        return new LocalReference("jar:" + jarFile.toString() + "!/" + entryPath);
    }

    public static LocalReference createRiapReference(int authorityType, String path) {
        return new LocalReference("riap://" + LocalReference.getAuthorityName(authorityType) + path);
    }

    public static String getAuthorityName(int authority) {
        String result = null;
        switch (authority) {
            case 1: {
                result = "class";
                break;
            }
            case 2: {
                result = "system";
                break;
            }
            case 3: {
                result = "thread";
                break;
            }
            case 5: {
                result = "application";
                break;
            }
            case 4: {
                result = "component";
            }
        }
        return result;
    }

    public static String localizePath(String path) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char nextChar = path.charAt(i);
            if (nextChar == '/' || nextChar == '\\') {
                result.append(File.separatorChar);
                continue;
            }
            result.append(nextChar);
        }
        return result.toString();
    }

    public static String normalizePath(String path) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char nextChar = path.charAt(i);
            if (nextChar == '\\') {
                result.append('/');
                continue;
            }
            result.append(nextChar);
        }
        return result.toString();
    }

    public LocalReference(Reference localRef) {
        super(localRef.toString());
    }

    public LocalReference(String localUri) {
        super(localUri);
    }

    public int getClapAuthorityType() {
        String authority;
        int result = 0;
        if (this.getSchemeProtocol().equals(Protocol.CLAP) && (authority = this.getAuthority()) != null) {
            if (authority.equalsIgnoreCase(LocalReference.getAuthorityName(1))) {
                result = 1;
            } else if (authority.equalsIgnoreCase(LocalReference.getAuthorityName(2))) {
                result = 2;
            } else if (authority.equalsIgnoreCase(LocalReference.getAuthorityName(3))) {
                result = 3;
            }
        }
        return result;
    }

    public int getRiapAuthorityType() {
        String authority;
        int result = 0;
        if (this.getSchemeProtocol().equals(Protocol.RIAP) && (authority = this.getAuthority()) != null) {
            if (authority.equalsIgnoreCase(LocalReference.getAuthorityName(5))) {
                result = 5;
            } else if (authority.equalsIgnoreCase(LocalReference.getAuthorityName(4))) {
                result = 4;
            }
        }
        return result;
    }

    public File getFile() {
        File result = null;
        if (this.getSchemeProtocol().equals(Protocol.FILE)) {
            String hostName = this.getAuthority();
            if (hostName == null || hostName.equals("") || hostName.equalsIgnoreCase("localhost")) {
                String filePath = this.getPath();
                result = new File(filePath);
            } else {
                throw new RuntimeException("Can't resolve files on remote host machines");
            }
        }
        return result;
    }

    public String getJarEntryPath() {
        int separatorIndex;
        String ssp;
        String result = null;
        if (this.getSchemeProtocol().equals(Protocol.JAR) && (ssp = this.getSchemeSpecificPart()) != null && (separatorIndex = ssp.indexOf("!/")) != -1) {
            result = ssp.substring(separatorIndex + 2);
        }
        return result;
    }

    public Reference getJarFileRef() {
        int separatorIndex;
        String ssp;
        Reference result = null;
        if (this.getSchemeProtocol().equals(Protocol.JAR) && (ssp = this.getSchemeSpecificPart()) != null && (separatorIndex = ssp.indexOf("!/")) != -1) {
            result = new Reference(ssp.substring(0, separatorIndex));
        }
        return result;
    }
}

