/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;
import org.restlet.util.Engine;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form
extends Series<Parameter> {
    public Form() {
    }

    public Form(int initialCapacity) {
        super(initialCapacity);
    }

    public Form(List<Parameter> delegate) {
        super(delegate);
    }

    public Form(Logger logger, Representation representation) {
        Engine.getInstance().parse(logger, this, representation);
    }

    public Form(Logger logger, String queryString, CharacterSet characterSet) {
        Engine.getInstance().parse(logger, this, queryString, characterSet, true);
    }

    public Form(Representation webForm) {
        this(Logger.getLogger(Form.class.getCanonicalName()), webForm);
    }

    public Form(String queryString) {
        this(Logger.getLogger(Form.class.getCanonicalName()), queryString, CharacterSet.UTF_8);
    }

    public Form(String queryString, CharacterSet characterSet) {
        this(Logger.getLogger(Form.class.getCanonicalName()), queryString, characterSet);
    }

    @Override
    public Parameter createEntry(String name, String value) {
        return new Parameter(name, value);
    }

    @Override
    public Series<Parameter> createSeries(List<Parameter> delegate) {
        if (delegate != null) {
            return new Form(delegate);
        }
        return new Form();
    }

    public String getQueryString() {
        return this.getQueryString(CharacterSet.UTF_8);
    }

    public String getQueryString(CharacterSet characterSet) {
        try {
            return this.encode(characterSet);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Representation getWebRepresentation() {
        return this.getWebRepresentation(CharacterSet.UTF_8);
    }

    public Representation getWebRepresentation(CharacterSet characterSet) {
        return new StringRepresentation(this.getQueryString(characterSet), MediaType.APPLICATION_WWW_FORM, null, characterSet);
    }

    public String encode() throws IOException {
        return this.encode(CharacterSet.UTF_8);
    }

    public String encode(CharacterSet characterSet) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append('&');
            }
            ((Parameter)this.get(i)).encode(sb, characterSet);
        }
        return sb.toString();
    }
}

