/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Filter;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.TransformRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
extends Filter {
    public static final int MODE_REQUEST = 1;
    public static final int MODE_RESPONSE = 2;
    private volatile int mode;
    private volatile CharacterSet resultCharacterSet;
    private volatile List<Encoding> resultEncodings;
    private volatile List<Language> resultLanguages;
    private volatile MediaType resultMediaType;
    private volatile Representation transformSheet;

    public Transformer(int mode, Representation transformSheet) {
        this.mode = mode;
        this.transformSheet = transformSheet;
        this.resultMediaType = MediaType.APPLICATION_XML;
        this.resultCharacterSet = null;
        this.resultEncodings = new CopyOnWriteArrayList<Encoding>();
        this.resultLanguages = new CopyOnWriteArrayList<Language>();
    }

    @Override
    protected void afterHandle(Request request, Response response) {
        if (this.getMode() == 2) {
            response.setEntity(this.transform(response.getEntity()));
        }
    }

    @Override
    protected int beforeHandle(Request request, Response response) {
        if (this.getMode() == 1) {
            request.setEntity(this.transform(request.getEntity()));
        }
        return 0;
    }

    public int getMode() {
        return this.mode;
    }

    public CharacterSet getResultCharacterSet() {
        return this.resultCharacterSet;
    }

    public List<Encoding> getResultEncodings() {
        return this.resultEncodings;
    }

    public List<Language> getResultLanguages() {
        return this.resultLanguages;
    }

    public MediaType getResultMediaType() {
        return this.resultMediaType;
    }

    public Representation getTransformSheet() {
        return this.transformSheet;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setResultCharacterSet(CharacterSet resultCharacterSet) {
        this.resultCharacterSet = resultCharacterSet;
    }

    public void setResultEncodings(List<Encoding> resultEncodings) {
        this.resultEncodings = resultEncodings;
    }

    public void setResultLanguages(List<Language> resultLanguages) {
        this.resultLanguages = resultLanguages;
    }

    public void setResultMediaType(MediaType resultMediaType) {
        this.resultMediaType = resultMediaType;
    }

    public void setTransformSheet(Representation transformSheet) {
        this.transformSheet = transformSheet;
    }

    public Representation transform(Representation source) {
        TransformRepresentation result = new TransformRepresentation(this.getContext(), source, this.getTransformSheet());
        if (this.resultLanguages != null) {
            result.getLanguages().addAll(this.getResultLanguages());
        }
        result.setCharacterSet(this.getResultCharacterSet());
        if (this.resultEncodings != null) {
            result.getEncodings().addAll(this.getResultEncodings());
        }
        result.setMediaType(this.getResultMediaType());
        return result;
    }
}

