/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.util.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Guard
extends Filter {
    public static final int AUTHENTICATION_INVALID = -1;
    public static final int AUTHENTICATION_MISSING = 0;
    public static final int AUTHENTICATION_STALE = 2;
    public static final int AUTHENTICATION_VALID = 1;
    public static final long DEFAULT_NONCE_LIFESPAN_MILLIS = 300000L;
    private static final String NAME_ATTRIBUTE_PRINCIPAL = "java.security.Principal";
    private Collection<String> domainUris = Collections.singleton("/");
    private long nonceLifespan = 300000L;
    private volatile String realm;
    private volatile boolean rechallengeEnabled = true;
    private volatile ChallengeScheme scheme;
    private final ConcurrentMap<String, char[]> secrets = new ConcurrentHashMap<String, char[]>();
    private String serverKey = "serverKey";

    public static Principal getPrincipal(Request request) {
        return (Principal)request.getAttributes().get(NAME_ATTRIBUTE_PRINCIPAL);
    }

    public Guard(Context context, ChallengeScheme scheme, String realm) {
        super(context);
        if (scheme == null) {
            throw new IllegalArgumentException("Please specify an authentication scheme. Use the 'None' challenge if no authentication is required.");
        }
        this.scheme = scheme;
        this.realm = realm;
    }

    public Guard(Context context, String realm, Collection<String> baseUris, String serverKey) {
        this(context, ChallengeScheme.HTTP_DIGEST, realm);
        this.domainUris = baseUris;
        this.serverKey = serverKey;
    }

    public void accept(Request request, Response response) {
        this.setPrincipal(request);
        super.doHandle(request, response);
    }

    public int authenticate(Request request) {
        return Engine.getInstance().authenticate(request, this);
    }

    public boolean authorize(Request request) {
        return true;
    }

    @Deprecated
    public void challenge(Response response) {
        this.challenge(response, false);
    }

    public void challenge(Response response, boolean stale) {
        Engine.getInstance().challenge(response, stale, this);
    }

    public boolean checkSecret(Request request, String identifier, char[] secret) {
        return this.checkSecret(identifier, secret);
    }

    @Deprecated
    protected boolean checkSecret(String identifier, char[] secret) {
        boolean result = false;
        char[] secret2 = this.findSecret(identifier);
        if (secret == null || secret2 == null) {
            result = secret == secret2;
        } else if (secret.length == secret2.length) {
            boolean equals = true;
            for (int i = 0; i < secret.length && equals; ++i) {
                equals = secret[i] == secret2[i];
            }
            result = equals;
        }
        return result;
    }

    @Override
    public int doHandle(Request request, Response response) {
        switch (this.authenticate(request)) {
            case 1: {
                if (this.authorize(request)) {
                    this.accept(request, response);
                    break;
                }
                this.forbid(response);
                break;
            }
            case 0: {
                this.challenge(response, false);
                break;
            }
            case -1: {
                if (this.isRechallengeEnabled()) {
                    this.challenge(response, false);
                    break;
                }
                this.forbid(response);
                break;
            }
            case 2: {
                this.challenge(response, true);
            }
        }
        return 0;
    }

    public char[] findSecret(String identifier) {
        return (char[])this.getSecrets().get(identifier);
    }

    public void forbid(Response response) {
        response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
    }

    public Collection<String> getDomainUris() {
        return this.domainUris;
    }

    public long getNonceLifespan() {
        return this.nonceLifespan;
    }

    public String getRealm() {
        return this.realm;
    }

    public ChallengeScheme getScheme() {
        return this.scheme;
    }

    public ConcurrentMap<String, char[]> getSecrets() {
        return this.secrets;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public boolean isRechallengeEnabled() {
        return this.rechallengeEnabled;
    }

    public void setDomainUris(Collection<String> domainUris) {
        this.domainUris = domainUris;
    }

    public void setNonceLifespan(long lifespan) {
        this.nonceLifespan = lifespan;
    }

    protected void setPrincipal(Request request) {
        String credentials;
        PrincipalImpl principal = null;
        ChallengeResponse challengeResponse = request.getChallengeResponse();
        if (challengeResponse != null && (credentials = challengeResponse.getIdentifier()) != null) {
            principal = new PrincipalImpl(credentials);
        }
        if (principal != null) {
            request.getAttributes().put(NAME_ATTRIBUTE_PRINCIPAL, principal);
        } else {
            request.getAttributes().remove(NAME_ATTRIBUTE_PRINCIPAL);
        }
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setRechallengeEnabled(boolean rechallengeEnabled) {
        this.rechallengeEnabled = rechallengeEnabled;
    }

    public void setScheme(ChallengeScheme scheme) {
        this.scheme = scheme;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = serverKey;
    }

    private class PrincipalImpl
    implements Principal,
    Serializable {
        private static final long serialVersionUID = -1842197948591956691L;
        private String name;

        private PrincipalImpl() {
        }

        public PrincipalImpl(String name) {
            if (name == null) {
                throw new IllegalArgumentException("The name must not be null");
            }
            this.name = name;
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (!(another instanceof Principal)) {
                return false;
            }
            Principal otherPrinc = (Principal)another;
            return this.getName().equals(otherPrinc.getName());
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }
}

