/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import org.restlet.data.Metadata;

public final class Method
extends Metadata {
    private static final String BASE_HTTP = "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html";
    private static final String BASE_WEBDAV = "http://www.webdav.org/specs/rfc2518.html";
    public static final Method CONNECT = new Method("CONNECT", "Used with a proxy that can dynamically switch to being a tunnel", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.9");
    public static final Method COPY = new Method("COPY", "Creates a duplicate of the source resource, identified by the Request-URI, in the destination resource, identified by the URI in the Destination header", "http://www.webdav.org/specs/rfc2518.html#METHOD_COPY");
    public static final Method DELETE = new Method("DELETE", "Requests that the origin server deletes the resource identified by the request URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.7");
    public static final Method GET = new Method("GET", "Retrieves whatever information (in the form of an entity) that is identified by the request URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.3");
    public static final Method HEAD = new Method("HEAD", "Identical to GET except that the server must not return a message body in the response", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.4");
    public static final Method LOCK = new Method("LOCK", "Used to take out a lock of any access type (WebDAV)", "http://www.webdav.org/specs/rfc2518.html#METHOD_LOCK");
    public static final Method MKCOL = new Method("MKCOL", "Used to create a new collection (WebDAV)", "http://www.webdav.org/specs/rfc2518.html#METHOD_MKCOL");
    public static final Method MOVE = new Method("MOVE", "Logical equivalent of a copy, followed by consistency maintenance processing, followed by a delete of the source (WebDAV)", "http://www.webdav.org/specs/rfc2518.html#METHOD_MOVE");
    public static final Method OPTIONS = new Method("OPTIONS", "Requests for information about the communication options available on the request/response chain identified by the URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.2");
    public static final Method POST = new Method("POST", "Requests that the origin server accepts the entity enclosed in the request as a new subordinate of the resource identified by the request URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.5");
    public static final Method PROPFIND = new Method("PROPFIND", "Retrieves properties defined on the resource identified by the request URI", "http://www.webdav.org/specs/rfc2518.html#METHOD_PROPFIND");
    public static final Method PROPPATCH = new Method("PROPPATCH", "Processes instructions specified in the request body to set and/or remove properties defined on the resource identified by the request URI", "http://www.webdav.org/specs/rfc2518.html#METHOD_PROPPATCH");
    public static final Method PUT = new Method("PUT", "Requests that the enclosed entity be stored under the supplied request URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.6");
    public static final Method TRACE = new Method("TRACE", "Used to invoke a remote, application-layer loop-back of the request message", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.8");
    public static final Method UNLOCK = new Method("UNLOCK", "Removes the lock identified by the lock token from the request URI, and all other resources included in the lock", "http://www.webdav.org/specs/rfc2518.html#METHOD_UNLOCK");
    private String uri;

    public static Method valueOf(String methodName) {
        Method result = null;
        if (methodName != null) {
            result = methodName.equalsIgnoreCase(GET.getName()) ? GET : (methodName.equalsIgnoreCase(POST.getName()) ? POST : (methodName.equalsIgnoreCase(HEAD.getName()) ? HEAD : (methodName.equalsIgnoreCase(OPTIONS.getName()) ? OPTIONS : (methodName.equalsIgnoreCase(PUT.getName()) ? PUT : (methodName.equalsIgnoreCase(DELETE.getName()) ? DELETE : (methodName.equalsIgnoreCase(CONNECT.getName()) ? CONNECT : (methodName.equalsIgnoreCase(COPY.getName()) ? COPY : (methodName.equalsIgnoreCase(LOCK.getName()) ? LOCK : (methodName.equalsIgnoreCase(MKCOL.getName()) ? MKCOL : (methodName.equalsIgnoreCase(MOVE.getName()) ? MOVE : (methodName.equalsIgnoreCase(PROPFIND.getName()) ? PROPFIND : (methodName.equalsIgnoreCase(PROPPATCH.getName()) ? PROPPATCH : (methodName.equalsIgnoreCase(TRACE.getName()) ? TRACE : (methodName.equalsIgnoreCase(UNLOCK.getName()) ? UNLOCK : new Method(methodName)))))))))))))));
        }
        return result;
    }

    public Method(String name) {
        this(name, null, null);
    }

    public Method(String name, String description) {
        this(name, description, null);
    }

    public Method(String name, String description, String uri) {
        super(name, description);
        this.uri = uri;
    }

    public boolean equals(Object object) {
        return object instanceof Method && ((Method)object).getName().equals(this.getName());
    }

    public String getUri() {
        return this.uri;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }
}

