/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.Map;
import java.util.TreeMap;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataService {
    private Encoding defaultEncoding = Encoding.IDENTITY;
    private Language defaultLanguage = Language.ENGLISH_US;
    private MediaType defaultMediaType = MediaType.APPLICATION_OCTET_STREAM;
    private Map<String, Metadata> metadataMappings = new TreeMap<String, Metadata>();

    public MetadataService() {
        this.addCommonExtensions();
    }

    public void addCommonExtensions() {
        this.addExtension("en", Language.ENGLISH);
        this.addExtension("es", Language.SPANISH);
        this.addExtension("fr", Language.FRENCH);
        this.addExtension("css", MediaType.TEXT_CSS);
        this.addExtension("doc", MediaType.APPLICATION_WORD);
        this.addExtension("gif", MediaType.IMAGE_GIF);
        this.addExtension("html", MediaType.TEXT_HTML);
        this.addExtension("ico", MediaType.IMAGE_ICON);
        this.addExtension("jpeg", MediaType.IMAGE_JPEG);
        this.addExtension("jpg", MediaType.IMAGE_JPEG);
        this.addExtension("js", MediaType.APPLICATION_JAVASCRIPT);
        this.addExtension("json", MediaType.APPLICATION_JSON);
        this.addExtension("pdf", MediaType.APPLICATION_PDF);
        this.addExtension("png", MediaType.IMAGE_PNG);
        this.addExtension("ppt", MediaType.APPLICATION_POWERPOINT);
        this.addExtension("rdf", MediaType.APPLICATION_RDF_XML);
        this.addExtension("txt", MediaType.TEXT_PLAIN);
        this.addExtension("svg", MediaType.IMAGE_SVG);
        this.addExtension("swf", MediaType.APPLICATION_FLASH);
        this.addExtension("xhtml", MediaType.APPLICATION_XHTML_XML);
        this.addExtension("xml", MediaType.TEXT_XML);
        this.addExtension("zip", MediaType.APPLICATION_ZIP);
    }

    public void addExtension(String extension, Metadata metadata) {
        this.metadataMappings.put(extension, metadata);
    }

    public Encoding getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public MediaType getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public String getExtension(Metadata metadata) {
        for (String extension : this.getMappings().keySet()) {
            if (!this.getMetadata(extension).equals(metadata)) continue;
            return extension;
        }
        return null;
    }

    public Map<String, Metadata> getMappings() {
        return this.metadataMappings;
    }

    public Metadata getMetadata(String extension) {
        return this.getMappings().get(extension);
    }

    public void setDefaultEncoding(Encoding defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setDefaultLanguage(Language defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setDefaultMediaType(MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }
}

