/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Guard
extends Filter {
    private final Map<String, char[]> secrets = new ConcurrentHashMap<String, char[]>();
    private ChallengeScheme scheme;
    private String realm;

    public Guard(Context context, ChallengeScheme scheme, String realm) {
        super(context);
        if (scheme == null) {
            throw new IllegalArgumentException("Please specify an authentication scheme. Use the 'None' challenge if no authentication is required.");
        }
        this.scheme = scheme;
        this.realm = realm;
    }

    public void accept(Request request, Response response) {
        super.doHandle(request, response);
    }

    public int authenticate(Request request) {
        ChallengeResponse cr;
        int result = 0;
        if (this.scheme != null && (cr = request.getChallengeResponse()) != null && this.scheme.equals(cr.getScheme())) {
            String identifier = request.getChallengeResponse().getIdentifier();
            char[] secret = request.getChallengeResponse().getSecret();
            if (identifier != null && secret != null) {
                result = this.checkSecret(identifier, secret) ? 1 : -1;
            }
        }
        return result;
    }

    protected boolean checkSecret(String identifier, char[] secret) {
        boolean result = false;
        char[] secret2 = this.findSecret(identifier);
        if (secret == null || secret2 == null) {
            result = secret == secret2;
        } else if (secret.length == secret2.length) {
            boolean equals = true;
            for (int i = 0; i < secret.length && equals; ++i) {
                equals = secret[i] == secret2[i];
            }
            result = equals;
        }
        return result;
    }

    public boolean authorize(Request request) {
        return true;
    }

    public void challenge(Response response) {
        response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        response.setChallengeRequest(new ChallengeRequest(this.scheme, this.realm));
    }

    @Override
    public void doHandle(Request request, Response response) {
        switch (this.authenticate(request)) {
            case 1: {
                if (this.authorize(request)) {
                    this.accept(request, response);
                    break;
                }
                this.forbid(response);
                break;
            }
            case 0: {
                this.challenge(response);
                break;
            }
            case -1: {
                this.forbid(response);
            }
        }
    }

    protected char[] findSecret(String identifier) {
        return this.getSecrets().get(identifier);
    }

    public void forbid(Response response) {
        response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
    }

    public Map<String, char[]> getSecrets() {
        return this.secrets;
    }
}

