/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.restlet.data.CharacterSet;
import org.restlet.resource.Representation;

public final class ByteUtils {
    public static ReadableByteChannel getChannel(InputStream inputStream) throws IOException {
        return inputStream != null ? Channels.newChannel(inputStream) : null;
    }

    public static WritableByteChannel getChannel(OutputStream outputStream) throws IOException {
        return outputStream != null ? Channels.newChannel(outputStream) : null;
    }

    public static ReadableByteChannel getChannel(final Representation representation) throws IOException {
        final Pipe pipe = Pipe.open();
        Thread writer = new Thread(){

            public void run() {
                try {
                    Pipe.SinkChannel wbc = pipe.sink();
                    representation.write(wbc);
                    wbc.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        writer.start();
        return pipe.source();
    }

    public static InputStream getStream(ReadableByteChannel readableChannel) throws IOException {
        return readableChannel != null ? Channels.newInputStream(readableChannel) : null;
    }

    public static InputStream getStream(final Representation representation) throws IOException {
        if (representation != null) {
            final PipeStream pipe = new PipeStream();
            Thread writer = new Thread(){

                public void run() {
                    try {
                        OutputStream os = pipe.getOutputStream();
                        representation.write(os);
                        os.write(-1);
                        os.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            };
            writer.start();
            return pipe.getInputStream();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream getStream(WritableByteChannel writableChannel) {
        OutputStream result = null;
        if (writableChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)writableChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                result = selectableChannel.isBlocking() ? Channels.newOutputStream(writableChannel) : new NbChannelOutputStream(writableChannel);
            }
        } else {
            result = new NbChannelOutputStream(writableChannel);
        }
        return result;
    }

    public static String toString(InputStream inputStream) {
        return ByteUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, CharacterSet characterSet) {
        String result = null;
        if (inputStream != null) {
            try {
                StringBuilder sb = new StringBuilder();
                InputStreamReader isr = null;
                isr = characterSet != null ? new InputStreamReader(inputStream, characterSet.getName()) : new InputStreamReader(inputStream);
                BufferedReader br = new BufferedReader(isr);
                int nextByte = br.read();
                while (nextByte != -1) {
                    sb.append((char)nextByte);
                    nextByte = br.read();
                }
                br.close();
                result = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void write(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
        if (readableChannel != null && writableChannel != null) {
            ByteUtils.write(Channels.newInputStream(readableChannel), Channels.newOutputStream(writableChannel));
        }
    }

    private ByteUtils() {
    }

    private static final class NbChannelOutputStream
    extends OutputStream {
        private WritableByteChannel channel;
        private Selector selector;
        private SelectionKey selectionKey;
        private SelectableChannel selectableChannel;

        public NbChannelOutputStream(WritableByteChannel channel) {
            this.channel = channel;
            if (!(channel instanceof SelectableChannel)) {
                throw new IllegalArgumentException("Invalid channel provided. Please use only selectable channels.");
            }
            this.selectableChannel = (SelectableChannel)((Object)channel);
            this.selector = null;
            this.selectionKey = null;
            if (this.selectableChannel.isBlocking()) {
                throw new IllegalArgumentException("Invalid blocking channel provided. Please use only non-blocking channels.");
            }
        }

        public void write(int b) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(new byte[]{(byte)b});
            if (this.channel != null && bb != null) {
                try {
                    while (bb.hasRemaining()) {
                        int bytesWritten = this.channel.write(bb);
                        if (bytesWritten < 0) {
                            throw new IOException("Unexpected negative number of bytes written.");
                        }
                        if (bytesWritten != 0) continue;
                        this.registerSelectionKey();
                        if (this.getSelector().select(10000L) != 0) continue;
                        throw new IOException("Unable to select the channel to write to it. Selection timed out.");
                    }
                }
                catch (IOException ioe) {
                    throw new IOException("Unable to write to the non-blocking channel. " + ioe.getLocalizedMessage());
                }
            } else {
                throw new IOException("Unable to write. Null byte buffer or channel detected.");
            }
        }

        private Selector getSelector() throws IOException {
            if (this.selector == null) {
                this.selector = Selector.open();
            }
            return this.selector;
        }

        private void registerSelectionKey() throws ClosedChannelException, IOException {
            this.selectionKey = this.selectableChannel.register(this.getSelector(), 4);
        }

        public void close() throws IOException {
            if (this.selectionKey != null) {
                this.selectionKey.cancel();
            }
            if (this.selector != null) {
                this.selector.close();
            }
            super.close();
        }
    }

    private static final class PipeStream {
        private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);

        public InputStream getInputStream() {
            return new InputStream(){
                private boolean endReached = false;

                public int read() throws IOException {
                    try {
                        if (this.endReached) {
                            return -1;
                        }
                        int value = (Integer)PipeStream.this.queue.take();
                        this.endReached = value == -1;
                        return value;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("Interruption occurred while writing in the queue");
                    }
                }
            };
        }

        public OutputStream getOutputStream() {
            return new OutputStream(){

                public void write(int b) throws IOException {
                    try {
                        PipeStream.this.queue.put(b);
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("Interruption occurred while writing in the queue");
                    }
                }
            };
        }
    }
}

