/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml.internal;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.ext.xml.XmlRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConverter
extends ConverterHelper {
    private static final Variant VARIANT_XML_APP = new Variant(MediaType.APPLICATION_XML);
    private static final Variant VARIANT_XML_TEXT = new Variant(MediaType.TEXT_XML);

    public List<Class<?>> getObjectClasses(Variant variant) {
        MediaType mediaType;
        List result = null;
        if (variant.getMediaType() != null && (MediaType.APPLICATION_ALL_XML.equals((Object)(mediaType = variant.getMediaType())) || MediaType.TEXT_XML.equals((Object)mediaType) || MediaType.APPLICATION_ATOMPUB_SERVICE.equals((Object)mediaType) || MediaType.APPLICATION_ATOM.equals((Object)mediaType) || MediaType.APPLICATION_RDF_XML.equals((Object)mediaType) || MediaType.APPLICATION_WADL.equals((Object)mediaType) || MediaType.APPLICATION_XHTML.equals((Object)mediaType))) {
            result = this.addObjectClass(result, Document.class);
            result = this.addObjectClass(result, XmlRepresentation.class);
        }
        return result;
    }

    public List<Variant> getVariants(Class<?> objectClass) {
        List result = null;
        if (Document.class.isAssignableFrom(objectClass) || DomRepresentation.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_XML_APP);
            result = this.addVariant(result, VARIANT_XML_TEXT);
        } else if (SaxRepresentation.class.isAssignableFrom(objectClass)) {
            result = this.addVariant(result, VARIANT_XML_APP);
            result = this.addVariant(result, VARIANT_XML_TEXT);
        }
        return result;
    }

    public <T> T toObject(Representation representation, Class<T> targetClass, UniformResource resource) throws IOException {
        Object result = null;
        if (representation != null) {
            if (targetClass != null) {
                if (targetClass.isAssignableFrom(representation.getClass())) {
                    result = representation;
                } else if (Document.class.isAssignableFrom(targetClass)) {
                    result = new DomRepresentation(representation).getDocument();
                } else if (DomRepresentation.class.isAssignableFrom(targetClass)) {
                    result = new DomRepresentation(representation);
                } else if (SaxRepresentation.class.isAssignableFrom(targetClass)) {
                    result = new SaxRepresentation(representation);
                }
            }
            if (result instanceof Representation) {
                Representation resultRepresentation = result;
                resultRepresentation.setCharacterSet(representation.getCharacterSet());
                resultRepresentation.setMediaType(representation.getMediaType());
                resultRepresentation.setEncodings(representation.getEncodings());
                resultRepresentation.setLanguages(representation.getLanguages());
            }
        }
        return (T)result;
    }

    public Representation toRepresentation(Object object, Variant targetVariant, UniformResource resource) throws IOException {
        DomRepresentation result = null;
        if (object instanceof Document) {
            result = new DomRepresentation(targetVariant == null ? null : targetVariant.getMediaType(), (Document)object);
        }
        if (result != null && targetVariant != null) {
            result.setCharacterSet(targetVariant.getCharacterSet());
            result.setMediaType(targetVariant.getMediaType());
            result.setEncodings(targetVariant.getEncodings());
            result.setLanguages(targetVariant.getLanguages());
        }
        return result;
    }
}

