/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.restlet.data.MediaType;
import org.restlet.ext.xml.XmlRepresentation;
import org.restlet.representation.Representation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.SAXException;

public class DomRepresentation
extends XmlRepresentation {
    private volatile Document dom;
    private volatile boolean indent;
    private volatile Representation xmlRepresentation;

    public DomRepresentation(MediaType mediaType) throws IOException {
        super(mediaType);
        this.dom = this.getDocumentBuilder().newDocument();
    }

    public DomRepresentation(MediaType mediaType, Document xmlDocument) {
        super(mediaType);
        this.dom = xmlDocument;
    }

    public DomRepresentation(Representation xmlRepresentation) {
        super(xmlRepresentation == null ? null : xmlRepresentation.getMediaType());
        this.xmlRepresentation = xmlRepresentation;
    }

    protected Transformer createTransformer() throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            DocumentType docType = this.getDocument().getDoctype();
            if (docType != null) {
                if (docType.getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", this.getDocument().getDoctype().getSystemId());
                }
                if (docType.getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", this.getDocument().getDoctype().getPublicId());
                }
                transformer.setOutputProperty("indent", Boolean.toString(this.isIndent()));
            }
            return transformer;
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException("Couldn't write the XML representation: " + tce.getMessage());
        }
    }

    public Object evaluate(String expression, QName returnType) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(this);
        return xpath.evaluate(expression, this.getDocument(), returnType);
    }

    public Document getDocument() throws IOException {
        if (this.dom == null) {
            if (this.xmlRepresentation != null) {
                try {
                    this.dom = this.getDocumentBuilder().parse(this.xmlRepresentation.getStream());
                }
                catch (SAXException se) {
                    throw new IOException("Couldn't read the XML representation. " + se.getMessage());
                }
            } else {
                this.dom = this.getDocumentBuilder().newDocument();
            }
        }
        return this.dom;
    }

    public DOMSource getDomSource() throws IOException {
        return new DOMSource(this.getDocument());
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void release() {
        this.setDocument(null);
        if (this.xmlRepresentation != null) {
            this.xmlRepresentation.release();
        }
        super.release();
    }

    public void setDocument(Document dom) {
        this.dom = dom;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            if (this.getDocument() != null) {
                Transformer transformer = this.createTransformer();
                transformer.transform(new DOMSource(this.getDocument()), new StreamResult(outputStream));
            }
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException("Couldn't write the XML representation: " + tce.getMessage());
        }
        catch (TransformerException te) {
            throw new IOException("Couldn't write the XML representation: " + te.getMessage());
        }
        catch (TransformerFactoryConfigurationError tfce) {
            throw new IOException("Couldn't write the XML representation: " + tfce.getMessage());
        }
    }
}

