/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepresentationResourceLoader
extends ResourceLoader {
    private static final Map<String, Representation> store = new ConcurrentHashMap<String, Representation>();
    private final Representation defaultRepresentation;

    public static Map<String, Representation> getStore() {
        return store;
    }

    public RepresentationResourceLoader(Representation defaultRepresentation) {
        this.defaultRepresentation = defaultRepresentation;
    }

    public long getLastModified(Resource resource) {
        Representation original = RepresentationResourceLoader.getStore().get(resource.getName());
        return original != null ? original.getModificationDate().getTime() : 0L;
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream result = null;
        try {
            Representation resultRepresentation = RepresentationResourceLoader.getStore().get(name);
            if (resultRepresentation == null) {
                resultRepresentation = this.defaultRepresentation;
                if (resultRepresentation == null) {
                    throw new ResourceNotFoundException("Could not locate resource '" + name + "'");
                }
                result = resultRepresentation.getStream();
            } else {
                result = resultRepresentation.getStream();
            }
        }
        catch (IOException ioe) {
            throw new ResourceNotFoundException((Throwable)ioe);
        }
        return result;
    }

    public void init(ExtendedProperties configuration) {
    }

    public boolean isSourceModified(Resource resource) {
        return this.getLastModified(resource) != resource.getLastModified();
    }
}

