/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public abstract class AnnotationInfo {
    protected final String annotationValue;
    protected final Class<?> javaClass;
    protected final Method javaMethod;
    protected final Method javaMethodImpl;

    protected static Class<?> getJavaActualType(Class<?> currentClass, String genericTypeName) {
        Class<?> result = null;
        result = AnnotationInfo.getJavaActualType(currentClass.getGenericSuperclass(), genericTypeName);
        if (result == null) {
            Type[] interfaceTypes = currentClass.getGenericInterfaces();
            for (int i = 0; result == null && i < interfaceTypes.length; ++i) {
                result = AnnotationInfo.getJavaActualType(interfaceTypes[i], genericTypeName);
            }
        }
        return result;
    }

    protected static Class<?> getJavaActualType(Type currentType, String genericTypeName) {
        Class<?> result = null;
        if (currentType != null) {
            if (currentType instanceof Class) {
                result = AnnotationInfo.getJavaActualType((Class)currentType, genericTypeName);
            } else if (currentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)currentType;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; result == null && i < actualTypeArguments.length; ++i) {
                    if (!genericTypeName.equals(typeParameters[i].getName())) continue;
                    result = AnnotationInfo.getTypeClass(actualTypeArguments[i]);
                }
            }
        }
        return result;
    }

    protected static Class<?> getTypeClass(Type type) {
        Type componentType;
        Class<?> componentClass;
        Class<?> result = null;
        if (type instanceof Class) {
            result = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            result = AnnotationInfo.getTypeClass(((ParameterizedType)type).getRawType());
        } else if (type instanceof GenericArrayType && (componentClass = AnnotationInfo.getTypeClass(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            result = Array.newInstance(componentClass, 0).getClass();
        }
        return result;
    }

    public AnnotationInfo(Class<?> javaClass, Method javaMethod, String value) {
        this.javaClass = javaClass;
        this.javaMethod = javaMethod;
        this.annotationValue = value;
        Method m = null;
        try {
            m = javaClass.getMethod(javaMethod.getName(), javaMethod.getParameterTypes());
        }
        catch (Exception e) {
            m = javaMethod;
        }
        this.javaMethodImpl = m != null ? m : javaMethod;
    }

    public boolean equals(Object other) {
        boolean result = other instanceof AnnotationInfo;
        if (result && other != this) {
            AnnotationInfo otherAnnotation = (AnnotationInfo)other;
            if (result) {
                boolean bl = result = this.getJavaMethod() == null && otherAnnotation.getJavaMethod() == null || this.getJavaMethod() != null && this.getJavaMethod().equals(otherAnnotation.getJavaMethod());
            }
            if (result) {
                boolean bl = result = this.getJavaClass() == null && otherAnnotation.getJavaClass() == null || this.getJavaClass() != null && this.getJavaClass().equals(otherAnnotation.getJavaClass());
            }
            if (result) {
                result = this.getAnnotationValue() == null && otherAnnotation.getAnnotationValue() == null || this.getAnnotationValue() != null && this.getAnnotationValue().equals(otherAnnotation.getAnnotationValue());
            }
        }
        return result;
    }

    public String getAnnotationValue() {
        return this.annotationValue;
    }

    protected Class<?> getJavaActualType(Class<?> initialType, Type genericType) {
        Class<?> result = initialType;
        try {
            if (genericType instanceof TypeVariable) {
                TypeVariable genericTypeVariable = (TypeVariable)genericType;
                String genericTypeName = genericTypeVariable.getName();
                result = AnnotationInfo.getJavaActualType(this.getJavaClass(), genericTypeName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public String toString() {
        return "AnnotationInfo [javaMethod: " + this.javaMethod + ", javaClass: " + this.javaClass + ", value: " + this.annotationValue + "]";
    }
}

