/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.util.List;
import org.restlet.data.Range;
import org.restlet.engine.header.HeaderWriter;

public class RangeWriter
extends HeaderWriter<Range> {
    public static String write(List<Range> ranges) {
        return new RangeWriter().append(ranges).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String write(Range range, long size) {
        StringBuilder b = new StringBuilder(range.getUnitName() + " ");
        if (range.getIndex() >= 0L) {
            b.append(range.getIndex());
            b.append("-");
            if (range.getSize() != -1L) {
                b.append(range.getIndex() + range.getSize() - 1L);
            } else {
                if (size == -1L) throw new IllegalArgumentException("The entity has an unknown size, can't determine the last byte position.");
                b.append(size - 1L);
            }
        } else if (range.getIndex() == -1L) {
            if (range.getSize() == -1L) throw new IllegalArgumentException("The range provides no index and no size, it is invalid.");
            if (size == -1L) throw new IllegalArgumentException("The entity has an unknown size, can't determine the last byte position.");
            if (range.getSize() > size) throw new IllegalArgumentException("The size of the range (" + range.getSize() + ") is higher than the size of the entity (" + size + ").");
            b.append(size - range.getSize());
            b.append("-");
            b.append(size - 1L);
        }
        if (size != -1L) {
            b.append("/").append(size);
            return b.toString();
        } else {
            b.append("/*");
        }
        return b.toString();
    }

    public RangeWriter append(List<Range> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return this;
        }
        this.append(ranges.get(0).getUnitName() + "=");
        for (int i = 0; i < ranges.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            this.append(ranges.get(i));
        }
        return this;
    }

    @Override
    public HeaderWriter<Range> append(Range range) {
        if (range.getIndex() >= 0L) {
            ((HeaderWriter)this).append(range.getIndex());
            this.append("-");
            if (range.getSize() != -1L) {
                ((HeaderWriter)this).append(range.getIndex() + range.getSize() - 1L);
            }
        } else if (range.getIndex() == -1L) {
            this.append("-");
            if (range.getSize() != -1L) {
                ((HeaderWriter)this).append(range.getSize());
            }
        }
        return this;
    }
}

