/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.Iterator;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Encoding;
import org.restlet.engine.application.DecodeRepresentation;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;

public class Decoder
extends Filter {
    private final boolean decodingRequest;
    private final boolean decodingResponse;

    public Decoder(Context context) {
        this(context, true, false);
    }

    public Decoder(Context context, boolean decodingRequest, boolean decodingResponse) {
        super(context);
        this.decodingRequest = decodingRequest;
        this.decodingResponse = decodingResponse;
    }

    @Override
    public void afterHandle(Request request, Response response) {
        if (this.isDecodingResponse() && this.canDecode(response.getEntity())) {
            response.setEntity(this.decode(response.getEntity()));
        }
    }

    @Override
    public int beforeHandle(Request request, Response response) {
        if (this.isDecodingRequest() && this.canDecode(request.getEntity())) {
            request.setEntity(this.decode(request.getEntity()));
        }
        return 0;
    }

    public boolean canDecode(Representation representation) {
        boolean result;
        boolean bl = result = representation != null && !representation.getEncodings().isEmpty();
        if (result) {
            boolean found = false;
            Iterator<Encoding> iter = representation.getEncodings().iterator();
            while (!found && iter.hasNext()) {
                found = !iter.next().equals(Encoding.IDENTITY);
            }
            result = found;
        }
        return result;
    }

    public Representation decode(Representation representation) {
        Representation result = representation;
        boolean supported = true;
        boolean identityEncodings = true;
        Iterator<Encoding> iter = representation.getEncodings().iterator();
        while (supported && iter.hasNext()) {
            Encoding encoding = iter.next();
            supported = DecodeRepresentation.getSupportedEncodings().contains(encoding);
            identityEncodings &= encoding.equals(Encoding.IDENTITY);
        }
        if (supported && !identityEncodings) {
            result = new DecodeRepresentation(representation);
        }
        return result;
    }

    public boolean isDecodingRequest() {
        return this.decodingRequest;
    }

    public boolean isDecodingResponse() {
        return this.decodingResponse;
    }
}

