/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;
import org.restlet.util.WrapperRepresentation;

public class BufferingRepresentation
extends WrapperRepresentation {
    private volatile byte[] buffer;
    private volatile boolean buffered;

    public BufferingRepresentation(Representation bufferedRepresentation) {
        super(bufferedRepresentation);
        this.setTransient(false);
    }

    private void buffer() throws IOException {
        if (!this.isBuffered() && this.getWrappedRepresentation().isAvailable()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getWrappedRepresentation().write(baos);
            baos.flush();
            this.setBuffer(baos.toByteArray());
            this.setBuffered(true);
        }
    }

    @Override
    public long getAvailableSize() {
        return this.getSize();
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public ReadableByteChannel getChannel() throws IOException {
        return NioUtils.getChannel(this.getStream());
    }

    @Override
    public Reader getReader() throws IOException {
        return BioUtils.getReader(this.getStream(), this.getCharacterSet());
    }

    @Override
    public long getSize() {
        try {
            this.buffer();
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to buffer the wrapped representation", e);
        }
        return this.getBuffer() != null ? (long)this.getBuffer().length : -1L;
    }

    @Override
    public InputStream getStream() throws IOException {
        this.buffer();
        return this.getBuffer() != null ? new ByteArrayInputStream(this.getBuffer()) : null;
    }

    @Override
    public String getText() throws IOException {
        this.buffer();
        if (this.getBuffer() != null) {
            return this.getCharacterSet() != null ? new String(this.getBuffer(), this.getCharacterSet().toCharset().name()) : new String(this.getBuffer());
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        try {
            this.buffer();
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.FINER, "Unable to buffer the wrapped representation", e);
        }
        return this.isBuffered();
    }

    protected boolean isBuffered() {
        return this.buffered;
    }

    protected void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    protected void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.buffer();
        if (this.getBuffer() != null) {
            outputStream.write(this.getBuffer());
        }
    }

    @Override
    public void write(WritableByteChannel writableChannel) throws IOException {
        this.buffer();
        if (this.getBuffer() != null) {
            writableChannel.write(ByteBuffer.wrap(this.getBuffer()));
        }
    }

    @Override
    public void write(Writer writer) throws IOException {
        String text = this.getText();
        if (text != null) {
            writer.write(text);
        }
    }
}

