/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.engine.local.DirectoryServerResource;
import org.restlet.engine.util.AlphaNumericComparator;
import org.restlet.engine.util.AlphabeticalComparator;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Finder;

public class Directory
extends Finder {
    private volatile Comparator<Reference> comparator;
    private volatile boolean deeplyAccessible;
    private volatile String indexName;
    private volatile boolean listingAllowed;
    private volatile boolean modifiable;
    private volatile boolean negotiatingContent;
    private volatile Reference rootRef;

    public Directory(Context context, Reference rootLocalReference) {
        super(context);
        String rootIdentifier = rootLocalReference.getTargetRef().getIdentifier();
        this.rootRef = rootIdentifier.endsWith("/") ? new Reference(rootIdentifier) : new Reference(rootIdentifier + "/");
        this.comparator = new AlphaNumericComparator();
        this.deeplyAccessible = true;
        this.indexName = "index";
        this.listingAllowed = false;
        this.modifiable = false;
        this.negotiatingContent = true;
        this.setTargetClass(DirectoryServerResource.class);
    }

    public Directory(Context context, String rootUri) {
        this(context, new Reference(rootUri));
    }

    public Comparator<Reference> getComparator() {
        return this.comparator;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Representation getIndexRepresentation(Variant variant, ReferenceList indexContent) {
        Representation result = null;
        if (variant.getMediaType().equals(MediaType.TEXT_HTML)) {
            result = indexContent.getWebRepresentation();
        } else if (variant.getMediaType().equals(MediaType.TEXT_URI_LIST)) {
            result = indexContent.getTextRepresentation();
        }
        return result;
    }

    public List<Variant> getIndexVariants(ReferenceList indexContent) {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.TEXT_HTML));
        result.add(new Variant(MediaType.TEXT_URI_LIST));
        return result;
    }

    public Reference getRootRef() {
        return this.rootRef;
    }

    @Override
    public void handle(Request request, Response response) {
        request.getAttributes().put("org.restlet.directory", this);
        super.handle(request, response);
    }

    public boolean isDeeplyAccessible() {
        return this.deeplyAccessible;
    }

    public boolean isListingAllowed() {
        return this.listingAllowed;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isNegotiatingContent() {
        return this.negotiatingContent;
    }

    @Deprecated
    public void setAlphaComparator() {
        this.useAlphaComparator();
    }

    @Deprecated
    public void setAlphaNumComparator() {
        this.useAlphaNumComparator();
    }

    public void setComparator(Comparator<Reference> comparator) {
        this.comparator = comparator;
    }

    public void setDeeplyAccessible(boolean deeplyAccessible) {
        this.deeplyAccessible = deeplyAccessible;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setListingAllowed(boolean listingAllowed) {
        this.listingAllowed = listingAllowed;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public void setNegotiatingContent(boolean negotiatingContent) {
        this.negotiatingContent = negotiatingContent;
    }

    public void setRootRef(Reference rootRef) {
        this.rootRef = rootRef;
    }

    public void useAlphaComparator() {
        this.setComparator(new AlphabeticalComparator());
    }

    public void useAlphaNumComparator() {
        this.setComparator(new AlphabeticalComparator());
    }
}

